import torch as th
import numpy as np
import math

def calc_true_trajectory(space, start, goal, N =63, timesteps = 1000, lr = 1e-3):
    traj = np.zeros((N, space.dim))
    for i in range(N):
        traj[i] = ((N-i)*start.numpy()+(i+1)*goal.numpy())/(N+1)
    traj = th.tensor(traj, dtype = th.float32, requires_grad=True)
    optimizer = th.optim.Adam([traj], lr = lr)
    for _ in range(timesteps):
        length = (space.calc_deltas(th.cat((start.unsqueeze(0), traj)), th.cat((traj,goal.unsqueeze(0))))**2).sum()
        optimizer.zero_grad()
        length.backward()
        optimizer.step()
    return th.cat((start.unsqueeze(0), traj.detach(), goal.unsqueeze(0)))
