for seed in {11..20}
do
    echo $seed
    python3 -m learn --space Matsumoto_-1 --log_dir ../exp/Matsumoto_-1/ACDQ-$seed --seed $seed --depth 6 --total_timesteps 20000000 --device cuda:0 --learning_rate 0.00003 &
    python3 -m learn --space CarLikeDisk --log_dir ../exp/CarLikeDisk/ACDQ-$seed --seed $seed --depth 8 --total_timesteps 80000000 --device cuda:0 &
    python3 -m ppo --space Matsumoto_-1 --log_dir ../exp/Matsumoto_-1/Seq-$seed --seed $seed --max_step 64 --total_timesteps 20000000 --device cuda:0 &
    python3 -m ppo --space CarLikeDisk --log_dir ../exp/CarLikeDisk/Seq-$seed --seed $seed --max_step 256 --total_timesteps 80000000 --device cuda:0 &
    CUDA_VISIBLE_DEVICES=0 python3 -m SGT_PG.sgt_pg_main SGT_PG/config/config_Matsumoto.yml $seed > /dev/null 2> /dev/null &
    CUDA_VISIBLE_DEVICES=0 python3 -m SGT_PG.sgt_pg_main SGT_PG/config/config_CarLikeDisk.yml $seed > /dev/null 2> /dev/null &
    python3 -m learn --space Matsumoto_-1 --log_dir ../exp/Matsumoto_-1/ACnotM-$seed --seed $seed --depth 6 --total_timesteps 20000000 --not_midpoint --device cuda:0  --learning_rate 0.00003 &
    python3 -m learn --space CarLikeDisk --log_dir ../exp/CarLikeDisk/ACnotM-$seed --seed $seed --depth 8 --total_timesteps 80000000 --not_midpoint --device cuda:0 &
    python3 -m learn --space Matsumoto_-1 --log_dir ../exp/Matsumoto_-1/ACalpha2-$seed --seed $seed --depth 6 --total_timesteps 20000000 --alpha 2.0 --device cuda:0  --learning_rate 0.00003 &
    python3 -m learn --space CarLikeDisk --log_dir ../exp/CarLikeDisk/ACalpha2-$seed --seed $seed --depth 8 --total_timesteps 80000000 --alpha 2.0 --device cuda:0 &
done

python3 -m learn --space Panda --log_dir ../exp/Panda/ACDQ-0 --depth 5 --total_timesteps 20000000 --device cuda:0 --eps 20. &
python3 -m ppo --space Panda --log_dir ../exp/Panda/Seq-0 --max_step 32 --total_timesteps 20000000 --device cuda:0 --eps 20. &
CUDA_VISIBLE_DEVICES=0 python3 -m SGT_PG.sgt_pg_main SGT_PG/config/config_Panda.yml 0 > /dev/null 2> /dev/null &
python3 -m learn --space Panda --log_dir ../exp/Panda/ACnotM-0 --not_midpoint --depth 5 --total_timesteps 20000000 --device cuda:0 --eps 20. &
python3 -m learn --space Panda --log_dir ../exp/Panda/ACDQ-0 --alpha 2.0 --depth 5 --total_timesteps 20000000 --device cuda:0 --eps 20. &
