import matplotlib.pyplot as plt
import numpy as np

import matplotlib

matplotlib.rcParams['pdf.fonttype'] = 42
matplotlib.rcParams['ps.fonttype'] = 42
plt.rcParams["font.size"] = 24

fig = plt.figure(figsize = (21, 8))

import sys

prob = "Matsumoto_-1"

algos = [("ACDQ-","Ours", 'solid', 3, 2),
         ("Seq-", "Seq", 'dashed', 3, 1),
         ("SGT_", "PG", 'dotted', 15, 1),
         ("ACnotM-","Inter", 'solid', 3, 1),
         ("ACalpha2-","2:1", 'dashdot', 3, 1),
]         

ax = fig.add_subplot(1,3,1)

for name, label, style, interval, lw in algos:
    ac_evals = []
    for seed in range(11,21):
        dire = "../exp/"
        s=seed
        ac_evals.append(np.load(dire+prob+"/"+name+str(s)+"/evaluations.npz"))

    leng = min([len(res["timesteps"]) for res in ac_evals])
    timesteps = ac_evals[0]["timesteps"][:leng:interval]
    success_rates = np.array([res["success_rates"][:leng:interval] for res in ac_evals])
    ax.errorbar(timesteps, np.mean(success_rates, axis=0), np.std(success_rates, axis=0)/np.sqrt(10), label = label, linestyle = style, lw = lw)

ax.set_title("Matsumoto Metric")

ax.set_xlabel("Timesteps")
ax.set_ylabel("Success Rate")

prob = "CarLikeDisk"

ax = fig.add_subplot(1,3,2)

for name, label, style, interval, lw in algos:
    ac_evals = []
    for seed in range(11,21):
        dire = "../exp/"
        s=seed
        ac_evals.append(np.load(dire+prob+"/"+name+str(s)+"/evaluations.npz"))
    
    leng = min([len(res["timesteps"]) for res in ac_evals])
    timesteps = ac_evals[0]["timesteps"][:leng:interval]
    success_rates = np.array([res["success_rates"][:leng:interval] for res in ac_evals])
    ax.errorbar(timesteps, np.mean(success_rates, axis=0), np.std(success_rates, axis=0)/np.sqrt(10), label = label, linestyle = style, lw = lw)
    #print(ac_evals[0]["timesteps"])

ax.set_title("Car-Like Metric")

ax.set_xlabel("Timesteps")
ax.set_ylabel("Success Rate")

prob = "Panda"

ax = fig.add_subplot(1,3,3)

for name, label, style, interval, lw in algos:
    dire = "../exp/"
    s=0
    res=np.load(dire+prob+"/"+name+str(s)+"/evaluations.npz")
    
    leng = len(res["timesteps"])
    timesteps = res["timesteps"][:leng:interval]
    success_rates = res["success_rates"][:leng:interval]
    ax.plot(timesteps, success_rates, label = label, linestyle = style, lw = lw)

ax.set_title("Robotic Arm")

ax.set_xlabel("Timesteps")
ax.set_ylabel("Success Rate")


fig.subplots_adjust(left=0.05, right=0.99, bottom=0.20, top=0.92)
plt.legend(bbox_to_anchor = (-0.7,-0.12,), loc = 'upper center', ncol = 5)
plt.savefig("../figures/graphs3.pdf")
plt.show()
