import torch as th
import numpy as np
from space import Space
class Euclid(Space):
    def __init__(self, dim):
        super().__init__(dim, (-th.ones(dim), th.ones(dim)))

    def F(self, states, d):
        return d.norm(dim=1)

    def F_np(self, state, d):
        return np.linalg.norm(d)
