# Learning Antidote Data to Individual Unfairness

## Baseline

1. Vanilla models: logistic regression, neural networks
1. SenDrop: drop the sensitive features from inputs
1. Project: a pre-processing approach to erase sensitive information via a linear mapping
1. SenSR: "Training individually fair ML models with Sensitive Subspace Robustness"
1. SenSeI: "Sensitive set invariance for enforcing individual fairness"
1. LCIFR: "Learning certified individually fair representations"

## Dataset

Organize a folder named `data` and store corresponding data following the below structure.

```
./data
    └ adult
    │    │ adult.data
    │    └ adult.test
    └ compas
    │    └ compas-scores-two-years.csv
    └ dutch
    │    └ dutch.csv
    └ law_school
    │    └ law_school.csv
    └ oulad
        └ anoymisedData
            └ studentInfo.csv
```

## Main Experiment

    python main.py --dataset adult --model_save --model_save_path ./save/adult.pt
