# ShreddingNet: Coarse-to-Fine Restoration for Multi-Source Shredded Manuscripts

Here are the supplementary materials for our paper. Our datasets, parameters and source code are included in the supplementary materials. Due to material size limitations, we have placed the datasets in Huggingface and provided their download links([art_2192](https://huggingface.co/datasets/Anonymous114514/art_2192) and [pex_2000](https://huggingface.co/datasets/Anonymous114514/pex_2000)). For the same reason, we only presented partial experimental results in the supplementary materials. However, we have provided detailed guidelines in this article so that you can reproduce our experimental results.

## Datasets

The raw datasets are categorized into two types: 
1. [art_2192](https://huggingface.co/datasets/Anonymous114514/art_2192), consists of 2,192 high-quality traditional Chinese landscape paintings. All paintings are sized $512\times 512$, from the four sources: 
   + Princeton University Art Museum
   + Harvard University Art Museum,
   + Metropolitan Museum of Art
   + Smithsonian's Freer Gallery of Art.
2. [pex_2000](https://huggingface.co/datasets/Anonymous114514/pex_2000), contains 2,000 high-resolution digital photographs resized and cropped from free-use stock photos from Pexels. All the images have minimum dimensions of 768p and maximum dimensions that are multiples of 32.

Each dataset contains three PKL files, namely train_set.pkl, valid_set.pkl, and test_set.pkl. The data structure of each PKL file is as follows:
```python
{
    "img_list": [], # list of image names
    'full_pcd_all': [], # list of the point clouds of fragments
    'img_all': [], # list of fragments
    'belong_image': [], # list of image names corresponding to fragments
    'shape_all': [], # list of fragment shapes
    "gt_pose": [], # list of ground truth poses of fragments
    'GT_pairs': [], # list of ground truth matching pairs of fragments ((u, v) means that the u-th fragment matches the v-th fragment)
    'source_ind': [], # Indicate how the fragment pairs are matched, and source_ind represents which contour points of the u fragment in (u, v) match the v fragment
    'target_ind': [], # Indicate how the fragment pairs are matched, and source_ind represents which contour points of the v fragment in (u, v) match the u fragment
    'intersection_len': [], # not use
}
```

## Parameters
We provide the parameters of three independently trained networks on two datasets:
+ `./results/art_2192/pairing_resgcn_2192`: for coarse matching net of art_2192.
+ `./results/art_2192/matching_resgcn_2192`: for fine-grained matching net of art_2192.
+ `./results/art_2192/classify_2192`: for score evaluation net of art_2192.
+ `./results/pex_2000/pairing_pex2000`: for coarse matching net of pex_2000.
+ `./results/pex_2000/matching_pex2000`: for fine-grained matching net of pex_2000.
+ `./results/pex_2000/classify_pex2000`: for score evaluation net of pex_2000.

Due to material size limitations, we only provided the optimal parameter `checkpoint_best.tar`, which is also the parameter used for all our tests.

## Results
Due to material size limitations, we only provide the results of the first 30 batches on the art_2192 (normal&hard) dataset.(in `./results/art_2192/normal` and `./results/art_2192/hard`) Each batch consists of all fragments generated from 3 complete images. In most cases, the model is able to restore all fragments into three complete images. On the hard dataset, due to the addition of high-density stains, mold spots, and some contour defects, the performance of the model is slightly inferior to the normal dataset, but it can still recover most of the images. 

For results not provided (such as those on the pex_2000 dataset), you can download the dataset and generate them yourself according to our guidelines. You can also use your own dataset for testing.

## Source code and guidelines
We have provided our complete source code in the supplementary materials. For your convenience in reproducing the experimental results, we have provided detailed guidelines here.

### Dependencies
We use the conda environment to manage our dependencies. You can create and activate a conda environment using the following command:
```bash
conda env create -f ./env.yaml
conda activate tqychy
```

### Data Preparation
We provide download links for the two datasets used in this study ([art_2192](https://huggingface.co/datasets/Anonymous114514/art_2192) and [pex_2000](https://huggingface.co/datasets/Anonymous114514/pex_2000)). You need to download the `test_set.pkl` files corresponding to each dataset and place them in the `./dataset/2192` directory (for art_2192) and the `./dataset/2000_pex` directory (for pex_2000). If you intend to use a different directory, please modify the `TEST_DATA_PATH` field in the corresponding configuration file under the `./config` directory to point to the directory containing the test set.

If you wish to synthesize a dataset using your own data, prepare the images and place them in a single directory. Configure the settings by following the example of the configuration files in the `./config/build_dataset` directory, and then run `bash ./dataset/build.sh` to generate the dataset.

### Testing
All hyperparameter configuration files used in the experiments are located in the `./config` directory, and you can modify these files as needed. If you relocate the parameter files or wish to use different parameter files, please adjust the relevant fields in the configuration files accordingly. By default, the experiment will generate log files in the `./log` directory and store results in subdirectories under `./results`. You can modify these directories as required. Once the adjustments are complete, use the following command to perform the testing:

```bash
bash ./test.sh
```

### Training
We have provided all necessary parameters in the supplementary materials, which you can directly use for testing. Re-training will consume significant time (approximately several days). If you insist on training from scratch, you can execute the following command:

```bash
bash ./train.sh
```