"""
@Description :   测试主函数
@Author      :   tqychy 
@Time        :   2025/01/17 14:43:03
"""
import argparse
import random
import warnings

import numpy as np
import torch

from config.default import cfg
from logger.logger import build_logger
from trainers import testers


def set_seed(seed: int, cuda_deterministic=True):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    if cuda_deterministic:
        torch.backends.cudnn.deterministic = True
        torch.backends.cudnn.benchmark = False
    else:
        torch.backends.cudnn.deterministic = False
        torch.backends.cudnn.benchmark = True


def main(cfg):
    logger, _ = build_logger(cfg)
    logger.info(cfg)
    set_seed(cfg.GLOBALS.SEED)
    type = cfg.TEST.TYPE
    tester = testers[type](cfg, logger)
    tester.test()


if __name__ == "__main__":
    # import os
    # os.environ['CUDA_VISIBLE_DEVICES'] = "1"
    warnings.filterwarnings("ignore")

    parser = argparse.ArgumentParser()
    parser.add_argument(
        "--config_path",
        type=str,
        default="./config/art_2192/strain_test/3.yaml"
    )
    args = parser.parse_args()
    cfg.merge_from_file(args.config_path)
    cfg.freeze()

    main(cfg)
