import math

from measure_coverage_patch import main as measure_coverage_patch, save_div
from measure_coverage_patch_multi import main as measure_coverage_patch_multi

for approach in [
    ("swt_lite_golden_test/mode_vanillafuzzy", "\\golden"),
    ("gpt-4-1106-preview__swt_bench_lite_aug1_bm25_diff_27k_cl100k__seed=0,temperature=0__test/mode_vanillafuzzy", "\\zsb"),
    ("gpt-4-1106-preview__swt_bench_lite_aug1_bm25_27k_cl100k__seed=0,temperature=0__test/mode_custom", "\\zsp"),
    ("gpt-4-1106-preview__swt_bench_lite_aug1_bm25_27k_cl100k__seed=1,temperature=07__test/mode_custom", "\\paf", ""),
    ("gpt-4-1106-preview__swt_bench_lite_aug1_bm25_27k_cl100k__seed=1,temperature=07__test/mode_custom", "\\libro", "gpt-4-1106-preview__libro_gpt-4-1106-preview__swt_bench_lite_aug1__test__test.jsonl"),
    ("acr_swt_bench_lite/mode_vanilla", "\\acr"),
    ("swe-agent-demo3__swt_bench_lite__test/mode_vanilla", "\\swea"),
    ("swe-agent-demo4__swt_bench_lite__test/mode_vanilla", "\\sweap"),
]:

    eval_dir = approach[0]
    name = approach[1]
    if "=07" in eval_dir:
        libro_dir = approach[2]
        ress = measure_coverage_patch_multi(f"evaluation_output/{eval_dir}", dataset="./datasets/swt_bench_lite_aug1_bm25_diff_27k_cl100k", split="test", seeds="1,2,3,4,5", setting="IDEAL" if "paf" in name else "LIBRO", libro_inference_results=f"inference_output/{libro_dir}")
    else:
        ress = measure_coverage_patch(f"evaluation_output/{eval_dir}", dataset="./datasets/swt_bench_lite_aug1_bm25_diff_27k_cl100k", split="test", fuzzy=False)
    non_applied_cases = [res for res in ress if res.get("message", None) is not None]
    no_all_cases = len(ress)
    applied_cases = [res for res in ress if res.get("message", None) is None and res["patch_executable"]]
    good_cases = [res for res in applied_cases if res["good_case"]]
    bad_cases = [res for res in applied_cases if not res["good_case"]]

    precision = save_div(sum(res["precision"] for res in applied_cases), len(applied_cases), "-")
    recall = save_div(sum(res["recall"] for res in applied_cases), len(applied_cases), "-")
    precision_good = save_div(sum(res["precision"] for res in good_cases), len(good_cases), "-")
    recall_good = save_div(sum(res["recall"] for res in good_cases), len(good_cases), "-")
    precision_bad = save_div(sum(res["precision"] for res in bad_cases), len(bad_cases), "-")
    recall_bad = save_div(sum(res["recall"] for res in bad_cases), len(bad_cases), "-")

    print(
        name + " & " + " & ".join(map(lambda x: f"{x*100:.1f}" if x != "-" else "{-}", [
            recall,
            recall_good,
            recall_bad,
        ])),
        end=" \\\\ \n"
    )
