import json
import math
from collections import defaultdict

from datasets import load_from_disk

from measure_coverage_patch import main as measure_coverage_patch, save_div, BLACKLIST
from measure_coverage_patch_multi import main as measure_coverage_patch_multi

dataset = "./datasets/swt_bench_lite_aug1_bm25_diff_27k_cl100k"
repos = []
num_instances_per_repo = defaultdict(int)
for example in load_from_disk(dataset)["test"]:
    if example["instance_id"] in BLACKLIST:
        continue
    repos.append(example["instance_id"].split("_")[0])
    num_instances_per_repo[example["instance_id"].split("_")[0]] += 1
repos = list(sorted(set(repos)))
print("," + ",".join(repos))

swe_bench_results: str = "results/experiments-swe-bench/20240402_sweagent_gpt4/results/results.json"

raw_swe_bench_ress = json.load(open(swe_bench_results))
swe_bench_ress = raw_swe_bench_ress["resolved"]
swe_bench_ress = [res for res in swe_bench_ress if res not in BLACKLIST]
swe_bench_ress_by_repo = defaultdict(list)
for res in swe_bench_ress:
    repo = res.split("_")[0]
    swe_bench_ress_by_repo[repo].append(res)
print("SWE Bench", end=",")
for repo in repos:
    if repo not in swe_bench_ress_by_repo:
        repo_ress = []
    else:
        repo_ress = swe_bench_ress_by_repo[repo]
    good_cases = len(repo_ress)
    print(100*good_cases / num_instances_per_repo[repo], end=",")
print()



for approach in [
    ("swe-agent-demo3__swt_bench_lite__test/mode_vanilla", "SWT Bench"),
]:

    eval_dir = approach[0]
    name = approach[1]
    ress = measure_coverage_patch(f"evaluation_output/{eval_dir}", dataset="./datasets/swt_bench_lite_aug1_bm25_diff_27k_cl100k", split="test", fuzzy=False)

    by_repo = defaultdict(list)
    for res in ress:
        repo = res["instance_id"].split("_")[0]
        by_repo[repo].append(res)

    print(name, end=",")
    for repo in repos:
        if repo not in by_repo:
            repo_ress = []
        else:
            repo_ress = by_repo[repo]
        good_cases = sum(res.get("good_case", 0) for res in repo_ress)
        print(100*good_cases / num_instances_per_repo[repo], end=",")
    print()



