# CAP

## Bilevel optimization

We display the performance of CAP on loss function design via bilevel optimization. Attributes, datasets, and functions could be chosen by changing configurations. All the configurations were set in yaml files.

Code: loss_search_dic.py for long-tail datasets and loss_search_dic_relu.py for long-tail datasets with noisy labels.

Example:

 (1)loss function design via bilevel optimization: 

```
python loss_search_dic.py --config [configuration]
```

 (2) Retrain: Running with 

``` 
python retraining.py --config [new configuration contains the value of dy and ly]
```

## Post-hoc logit adjustment

We display the performance of CAP on loss function design via post-hoc logit adjustment. 

Code: train_posthoc_order1_v4_joint.py for long-tail datasets with balanced error as objective. Results in Table 3 are generated with this code. 

Example: 

(1) Get the imbalance pretrained model and save the logit value. Running with: 

```
python loss_search.py --config [configuration]
```

 (2) Run post-hoc logit adjustment training. Running with:

```
python train_posthoc_order1_v4_joint.py --ly True --dy False --joint ly_dy --dic_freq True --runs [file name]
```

(3) Retrain. Running with:

```
python retraining.py --config [new configuration contains the value of dy and ly]
```

## Objectives

The code for different fairness objectives beyond balanced accuracy was packed in the folder called objective.

Example: 

(1) Repeat the first step for post-hoc logit adjustment to get the logit value. 

(2) Using the corresponding code related to the methods and objectives. For example, running with

```
python train_posthoc_order1_v4_tradeoff.py --a 0.1
```

for aggregation of errors.





