import scipy.io as sio
import numpy as np
import torch
import torch.nn as nn
import torch.nn.functional as F
import torch.optim as optim
from torch.utils.data import TensorDataset
from torch.utils.data import DataLoader
import matplotlib.pyplot as plt
from torch.nn.functional import one_hot
from sklearn.preprocessing import StandardScaler
from sklearn.decomposition import PCA
import yaml
import time

device = "cuda"

import argparse
parser=argparse.ArgumentParser()
parser.add_argument('--noisy',dest='noisy',default='False',type=str)
parser.add_argument('--dic',dest='dic',default='True',type=str)
parser.add_argument('--dataset',dest='dataset',default='cifar100',type=str)
parser.add_argument('--batch_size', dest='batch_size', default=1024, type=int)
parser.add_argument('--epoch_change', dest='epoch_change', default=800, type=int)
parser.add_argument('--epoch', dest='epoch', default=1600, type=int)
parser.add_argument('--runs', dest='runs', default='2_500', type=str)
parser.add_argument('--train_rho', dest='train_rho', default=0.01, type=float)
parser.add_argument('--dy', dest='dy', default='True', type=str)
parser.add_argument('--ly', dest='ly', default='True', type=str)
parser.add_argument('--dic_error', dest='dic_error', default='True', type=str)
parser.add_argument('--dic_freq', dest='dic_freq', default='True', type=str)
parser.add_argument('--dic_norm', dest='dic_norm', default='False', type=str)
parser.add_argument('--dic_noise', dest='dic_noise', default='False', type=str)
parser.add_argument('--n_dic', dest='n_dic', default=None, type=int)
parser.add_argument('--test_size', dest='test_size', default=50, type=int)
parser.add_argument('--test', dest='test', default='True', type=str)
parser.add_argument('--aug_test', dest='aug_test',default='True', type=str)  
parser.add_argument('--earlystop', dest='earlystop',default='True', type=str)  
parser.add_argument('--joint', dest='joint',default='ly_dy', type=str)
parser.add_argument('--a', dest='a', default=0.1, type=float)
parser.add_argument('--accumulation_step', dest='accumulation_step', default=5, type=int)
#parser.add_argument('--lr_warmup', dest='lr_warmup', default=10, type=int)
#parser.add_argument('--lr_schedule', dest='lr_schedule', default='False', type=str)
args=parser.parse_args()

dataset=args.dataset  # Dataset, either Cifar10 or Cifar100
batch_size=args.batch_size # Training batchsize
total_epoch=args.epoch # Total training epoch
switch_epoch =args.epoch_change
train_rho=args.train_rho # Imbalance ratio : Min/Max
runs=args.runs
if args.noisy == 'True':
    save_path= f'./results/{dataset}/noisy/{runs}/post_hoc'
else:
    save_path= f'./results/{dataset}/simple/split_no/{runs}/post_hoc'
    #save_path= f'./results/{dataset}/simple/split/{runs}/post_hoc'
    #save_path= f'./results/{dataset}/dyly_dic_warmup/{runs}/post_hoc'
#save_path= f'./results/{dataset}/simple/balance/{runs}/post_hoc'
if dataset=='cifar10':
    num_classes=10
elif dataset=='cifar100':
    num_classes=100
if args.joint == 'ly_dy':
    args.epoch_ly = args.epoch_change
    args.epoch_dy = args.epoch
if args.joint == 'dy_ly':
    args.epoch_dy = args.epoch_change
    args.epoch_ly = args.epoch
num_workers = 2

# load data
train_mdic = sio.loadmat(f'{save_path}/train_logits.mat')
if args.test == 'True':
    if args.test_size == 10000/num_classes or args.test_size > 10000/num_classes:
        val_mdic = sio.loadmat(f'{save_path}/test_logits.mat')
    else:
        if args.aug_test == 'True':
            val_mdic = sio.loadmat(f'{save_path}/aug{args.aug_test}_{args.test_size}_test_logits.mat')
        else: 
            val_mdic = sio.loadmat(f'{save_path}/{args.test_size}_test_logits.mat')
else:
    val_mdic = sio.loadmat(f'{save_path}/val_logits.mat')
test_mdic = sio.loadmat(f'{save_path}/test_logits.mat')
model_mdic = sio.loadmat(f'{save_path}/normB.mat')
model_norm = model_mdic['normB'][0]
if args.noisy == 'True':
    model_r_i = sio.loadmat(f'{save_path}/r_i.mat')
    r_i = model_r_i['r_i'][0]
    print(r_i)


train_label_all = train_mdic['label_all'][0]
train_loss_all = train_mdic['loss_all'][0]
train_acc_all = train_mdic['acc_all'][0]
train_logits_all = train_mdic['logits_all']
num_class_i = np.zeros([num_classes])
if args.noisy == 'True':
    for i in range(np.shape(train_label_all)[0]):
        num_class_i[train_label_all[i]] = num_class_i[train_label_all[i]]+1
    print('train class num',num_class_i)

val_label_all = val_mdic['label_all'][0]
val_loss_all = val_mdic['loss_all'][0]
val_acc_all = val_mdic['acc_all'][0]
val_logits_all = val_mdic['logits_all']
if args.noisy == 'True':
    print('val size',np.shape(val_label_all))
    num_class_i = np.zeros([num_classes])
    for i in range(np.shape(val_label_all)[0]):
        num_class_i[val_label_all[i]] = num_class_i[val_label_all[i]]+1
    print('val class num',num_class_i)
val_dataset = TensorDataset(torch.Tensor(val_label_all).to(dtype=torch.long),torch.Tensor(val_logits_all))
val_loader = DataLoader(val_dataset, batch_size=batch_size, num_workers=num_workers, shuffle=True, drop_last=True, pin_memory=True)

test_label_all = test_mdic['label_all'][0]
test_loss_all = test_mdic['loss_all'][0]
test_acc_all = test_mdic['acc_all'][0]
test_logits_all = test_mdic['logits_all']
if args.noisy == 'True':
    print('test size',np.shape(test_label_all))
    num_class_i = np.zeros([num_classes])
    for i in range(np.shape(test_label_all)[0]):
        num_class_i[test_label_all[i]] = num_class_i[test_label_all[i]]+1
    print('test class num',num_class_i)
test_dataset = TensorDataset(torch.Tensor(test_label_all).to(dtype=torch.long),torch.Tensor(test_logits_all))
test_loader = DataLoader(test_dataset, batch_size=batch_size, num_workers=num_workers, shuffle=True, drop_last=False, pin_memory=True)

def logit_adjust(logits,params):
    #assert(len(params)==2)
    #print(np.shape(logits))
    #print(np.shape(params))
    dy=params[0]
    ly=params[1]
    if args.dy == 'False':
        x=logits-ly
    else:
        x=logits/torch.sigmoid(dy)-ly
    return x

def eval_final(logits,label,logit_adjust,params,class_wise,num_classes):
    total=np.shape(label)[0]
    class_correct=np.zeros(num_classes,dtype=float)
    class_total=np.zeros(num_classes,dtype=float)
    if not logit_adjust is None:
        logits=logit_adjust(torch.Tensor(logits).cuda(),params)
        logits = logits.cpu().detach().numpy()
    preds = np.argmax(logits,axis = 1)
    correct =np.sum(preds==label)
    if class_wise:
        for i in range(num_classes):
            indexes=np.where(label==i)[0]
            class_total[i] =np.shape(indexes)[0]
            acc = preds==label
            class_correct[i] =np.sum(acc[indexes])
    return class_correct/class_total,correct/total
@torch.no_grad()
def compute_loss(data,targets,params,logit_adjust,num_classes):
    if not logit_adjust is None:
        data_adj = logit_adjust(torch.Tensor(data).cuda(),params)
    targets = torch.Tensor(targets).to(dtype=torch.long).cuda()
    one_hot = F.one_hot(targets,num_classes = num_classes)
    class_num = torch.sum(one_hot,axis=0)
    #print('class_num',np.shape(class_num))
    #print('class sum',torch.sum(class_num))
    loss = F.cross_entropy(data_adj,targets,reduction='none')
    class_loss = torch.mm(torch.reshape(loss.float(),(1,-1)),one_hot.float())
    class_loss_avg = class_loss/(class_num+0.0001)
    class_freq_torch = torch.tensor(class_freq).cuda()
    std_acc = torch.sum((class_loss_avg*class_freq_torch)/torch.sum(class_freq_torch))
    std_dev = torch.std(class_loss_avg)
    loss = args.a*std_acc+(1-args.a)*std_dev
    return loss.cpu().item()

class_freq=[]
val_rho = 0.01
val_mu=val_rho**(1./(num_classes-1))
for i in range(num_classes):
    class_freq.append(val_mu**i)
print(class_freq)

'''
if num_classes == 100:
    for i in range(num_classes):
        if i%10 == 0:
            class_freq.append(val_mu**i)
else:
    for i in range(num_classes):
        class_freq.append(val_mu**i)
'''
#class_freq = torch.Tensor(class_freq).cuda()

# no posthoc
class_wise_acc,acc = eval_final(test_logits_all,test_label_all,logit_adjust = None,params = None,class_wise = True,num_classes = num_classes)
print('test_class_wise_acc',class_wise_acc)
print('test acc',acc)
print('test min acc',np.min(class_wise_acc))
print('test std',np.std(class_wise_acc))
print('test mean error',1-np.mean(class_wise_acc))
print('test error',1-np.sum((class_freq*class_wise_acc)/np.sum(class_freq)))

class_wise_acc_dic = class_wise_acc
# no posthoc
class_wise_acc,acc = eval_final(val_logits_all,val_label_all,logit_adjust = None,params = None,class_wise = True,num_classes = num_classes)
print('val class_wise_acc',class_wise_acc)
print('val acc',acc)
print('val mean acc',np.mean(class_wise_acc))

def loss_objective(logits,targets):
    one_hot = F.one_hot(targets,num_classes = num_classes)
    class_num = torch.sum(one_hot,axis=0)
    #print('class_num',np.shape(class_num))
    #print('class sum',torch.sum(class_num))
    loss = F.cross_entropy(logits,targets,reduction='none')
    class_loss = torch.mm(torch.reshape(loss.float(),(1,-1)),one_hot.float())
    class_loss_avg = class_loss/(class_num+0.0001)
    class_freq_torch = torch.tensor(class_freq).cuda()
    # print(class_loss_avg.size())
    # print(class_freq_torch.size())
    # print(torch.sum((class_loss_avg*class_freq_torch)))
    
    std_acc = torch.sum((class_loss_avg*class_freq_torch)/torch.sum(class_freq_torch))
    std_dev = torch.std(class_loss_avg)
    loss = args.a*std_acc+(1-args.a)*std_dev
    return loss

def make_model(num_classes):
    # simple training(d and l)
    dy=torch.ones([num_classes],dtype=torch.float32,device=device)
    ly=torch.zeros([num_classes],dtype=torch.float32,device=device)
    if args.dy == 'True':
        dy.requires_grad=True
    else:
        dy.requires_grad=False

    if args.ly == 'True':
        ly.requires_grad=True
    else:
        ly.requires_grad=False


    criterion = loss_objective
    optimizer_dy = optim.SGD([dy],lr=0.001,momentum=0.9, weight_decay=1e-4)
    optimizer_ly = optim.SGD([ly],lr=0.001,momentum=0.9, weight_decay=1e-4)

    scheduler_dy=optim.lr_scheduler.MultiStepLR(optimizer_dy,milestones=[args.epoch_dy-120,args.epoch_dy-100,args.epoch_dy-180,args.epoch_dy-40],gamma=0.5)
    scheduler_ly=optim.lr_scheduler.MultiStepLR(optimizer_ly,milestones=[args.epoch_ly-120,args.epoch_ly-100,args.epoch_ly-180,args.epoch_ly-40],gamma=0.5)
    #scheduler = optim.lr_scheduler.LambdaLR(optimizer, lr_lambda=warm_up_with_multistep)
    return dy,ly,criterion,optimizer_dy,optimizer_ly,scheduler_dy,scheduler_ly



if args.test == 'True':
    w_val = torch.ones([num_classes],dtype=torch.float32, device=device)
else:
    w_val=np.sum(class_freq)/class_freq
    w_val=w_val/np.linalg.norm(w_val)
    w_val=torch.tensor(w_val,dtype=torch.float32, device=device)
w_val.requires_grad=False

args.wy = w_val
dy,ly,criterion,optimizer_dy,optimizer_ly,scheduler_dy,scheduler_ly = make_model(num_classes = num_classes)
import os
result_path = f'{save_path}/trade_off/nodic_a{args.a}_joint{args.joint}_earlystop{args.earlystop}_sigmoid_test{args.test_size}_freq{args.dic_freq}_error{args.dic_error}_norm{args.dic_norm}_noise{args.dic_noise}_dy{args.dy}_ly{args.ly}'
if not os.path.exists(result_path):
    os.makedirs(result_path)

def train(dy,ly,criterion,optimizer_1,optimizer_2,scheduler_1,scheduler_2,total_epoch,switch_epoch,num_classes):
    test_class_wise_acc_all = []
    test_mean_acc_all = []
    val_class_wise_acc_all = []
    val_mean_acc_all = []
    test_worst_acc_all = []
    val_worst_acc_all = []
    val_loss_all = []
    test_loss_all = []
    dy_all = []
    ly_all = []
    best_val_acc = 0
    for epoch in range(total_epoch):
        loss_all = 0
        num_all = 0
        if epoch <switch_epoch:
            optimizer = optimizer_1
            scheduler = scheduler_1
            if args.joint == 'ly_dy' and args.ly == 'False':
                continue
            if args.joint == 'dy_ly' and args.dy == 'False':
                continue
        else:
            optimizer = optimizer_2
            scheduler = scheduler_2    
            if args.joint == 'ly_dy' and args.dy == 'False':
                continue
            if args.joint == 'dy_ly' and args.ly == 'False':
                continue 
        if args.earlystop == 'True' and epoch == switch_epoch:
            print('previous_ly',ly)
            if args.joint == 'ly_dy':
                ly = best_ly.clone().detach()
            else:
                dy = best_dy.clone().detach()
            print('best_ly',ly)
        sum_loss = 0
        for cur_iter,(val_label_i,val_logits_i) in enumerate(val_loader):
            data,target = val_logits_i.cuda(),val_label_i.cuda(non_blocking=True)
            if num_classes == 100:
                dy_100=torch.ones([num_classes],dtype=torch.float32,device=device)
                ly_100=torch.zeros([num_classes],dtype=torch.float32,device=device)  
                for i in range(10):
                    dy_100[i*10:(i+1)*10] = dy[i]*torch.ones([10],dtype=torch.float32,device=device)
                    ly_100[i*10:(i+1)*10] = ly[i]*torch.ones([10],dtype=torch.float32,device=device)
                dy_class = dy_100
                ly_class = ly_100
            else:
                dy_class = dy
                ly_class = ly  
            data_adj = logit_adjust(data,[dy_class,ly_class])
            iter_loss = criterion(data_adj, target)/args.accumulation_step
            '''
            iter_loss.backward()
            if (cur_iter+1) % args.accumulation_step == 0:
                optimizer.zero_grad()
                optimizer.step()
            '''
            optimizer.zero_grad()
            iter_loss.backward()
            optimizer.step()

            loss_all+=iter_loss.item()
            num_all+=np.shape(target)[0]
        #model.eval()
        #params_1 = model(torch.Tensor(params_0).cuda())
        #params = torch.reshape(params_1,[2,-1])
        #print('lr: ',optimizer.param_groups[0]['lr'])
        dy_all.append(dy_class.cpu().detach().numpy())
        ly_all.append(ly_class.cpu().detach().numpy())
        val_loss = compute_loss(val_logits_all,val_label_all,logit_adjust = logit_adjust,num_classes = num_classes,params = [dy_class,ly_class])
        test_loss = compute_loss(test_logits_all,test_label_all,logit_adjust = logit_adjust,num_classes = num_classes,params = [dy_class,ly_class])
        scheduler.step()
        class_wise_acc,acc = eval_final(test_logits_all,test_label_all,logit_adjust = logit_adjust,params = [dy_class,ly_class],class_wise = True,num_classes = num_classes)
        val_class_wise_acc,val_acc = eval_final(val_logits_all,val_label_all,logit_adjust = logit_adjust,params = [dy_class,ly_class],class_wise = True,num_classes = num_classes)
        if val_acc>best_val_acc:
            best_test_acc = acc
            best_val_acc = val_acc
            best_epoch = epoch
            best_dy = dy_class.clone().detach()
            best_ly = ly_class.clone().detach()
        #print('class_wise_acc',class_wise_acc)
        #print('acc',acc)
        #print('loss',loss_all/num_all)
        val_class_wise_acc_all.append(val_class_wise_acc)
        val_mean_acc_all.append(val_acc)
        test_class_wise_acc_all.append(class_wise_acc)
        test_mean_acc_all.append(acc)
        test_worst_acc_all.append(np.min(class_wise_acc))
        val_worst_acc_all.append(np.min(val_class_wise_acc))
        val_loss_all.append(val_loss)
        test_loss_all.append(test_loss)
    return best_test_acc,best_val_acc,best_epoch,best_dy,best_ly,test_class_wise_acc_all,test_mean_acc_all,val_class_wise_acc_all,val_mean_acc_all,test_worst_acc_all,val_worst_acc_all,val_loss_all,test_loss_all,dy_all,ly_all
    model,criterion,optimizer,scheduler = make_model(num_classes = 10)
#params_0 = np.ones((2*10))
#params_0 = np.hstack((np.ones_like(class_freq)-class_freq,np.ones_like(class_wise_acc_10)-class_wise_acc_10))
#params_0 = np.hstack((np.ones_like(class_freq)-class_freq,np.ones_like(class_wise_acc_10)))
#params_0 = np.hstack((np.ones_like(class_wise_acc_10)-class_wise_acc_10,np.ones_like(class_freq)))
print('train')
if args.joint == 'ly_dy':
    optimizer_1 = optimizer_ly
    optimizer_2 = optimizer_dy
    scheduler_1 = scheduler_ly
    scheduler_2 = scheduler_dy   
if args.joint == 'dy_ly':
    optimizer_1 = optimizer_dy
    optimizer_2 = optimizer_ly
    scheduler_1 = scheduler_dy
    scheduler_2 = scheduler_ly   
print('train')
start_time = time.time()
best_test_acc,best_val_acc,best_epoch,best_dy,best_ly,test_class_wise_acc_all,test_mean_acc_all,val_class_wise_acc_all,val_mean_acc_all,test_worst_acc_all,val_worst_acc_all,val_loss_all,test_loss_all,dy_all,ly_all = train(dy,ly,criterion,optimizer_1,optimizer_2,scheduler_1,scheduler_2,total_epoch,switch_epoch,num_classes=num_classes)
end_time = time.time()
if args.dy == 'False':
    dy_final = np.ones([num_classes]).tolist()
else:
    if args.earlystop == 'True':
        dy_final = (torch.sigmoid(best_dy)).tolist()
    else:
        dy_final = torch.sigmoid(torch.tensor(np.array(dy_all)[-1,:])).tolist()
if args.earlystop == 'True':
    ly_final = best_ly.tolist()
else:
    ly_final = (np.array(ly_all)[-1,:]).tolist()

#dy_final = torch.sigmoid(torch.tensor(np.array(dy_all)[-1,:])).tolist()
result_file = {'dy' : dy_final,'ly':ly_final,'w_train':(np.ones([num_classes])).tolist(),'test_class_wise_acc_all':test_mean_acc_all,'test_mean_acc_all':test_mean_acc_all}
#result_file = [{'dy' : (best_dy).tolist()},{'ly':(best_ly).tolist()},{'w_train',(np.ones([num_classes])).tolist()},{'w_val',(np.ones([num_classes])).tolist()}]
with open(f'{result_path}/result.yaml', mode='w') as file:
    documents = yaml.dump(result_file, file)

plt.figure()
for ii in range(np.shape(dy_all)[1]):
    plt.plot(np.array(dy_all)[:,ii],label=str(ii))
    plt.scatter([best_epoch],np.array(dy_all)[best_epoch,ii])
plt.grid()
plt.legend()
plt.savefig(f'{result_path}/try_dic_dy.png')
plt.show()
plt.figure()
for ii in range(np.shape(ly_all)[1]):
    plt.plot(np.array(ly_all)[:,ii],label=str(ii))
    plt.scatter([best_epoch],np.array(ly_all)[best_epoch,ii])
plt.legend()
plt.grid()
plt.savefig(f'{result_path}/try_dic_ly.png')
plt.show()
plt.figure()
for ii in range(np.shape(test_class_wise_acc_all)[1]):
    plt.plot(np.array(test_class_wise_acc_all)[:,ii],label=str(ii))
    plt.scatter([best_epoch],np.array(test_class_wise_acc_all)[best_epoch,ii])
plt.legend()
plt.grid()
plt.savefig(f'{result_path}/test_class_wise_acc_all.png')
plt.show()


params = [best_dy,best_ly]
class_wise_acc,acc = eval_final(test_logits_all,test_label_all,logit_adjust = logit_adjust,params = params,class_wise = True,num_classes = num_classes)
print('dy',dy)
print('ly',ly)
print('test_class_wise_acc',class_wise_acc)
print('test_acc',acc)
print('test_min acc',np.min(class_wise_acc))
print('test std',np.std(class_wise_acc))
print('test mean error',1-np.mean(class_wise_acc))
print('test error',1-np.sum((class_freq*class_wise_acc)/np.sum(class_freq)))


val_class_wise_acc,val_acc = eval_final(val_logits_all,val_label_all,logit_adjust = logit_adjust,params = params,class_wise = True,num_classes = num_classes)
#print('val_class_wise_acc',class_wise_acc)
print('val_acc',val_acc)
print('val_min acc',np.min(val_class_wise_acc))
plt.figure()
plt.plot(val_loss_all,label = 'val')
plt.plot(test_loss_all,label = 'test')
plt.scatter([best_epoch],np.array(val_loss_all)[best_epoch])
plt.scatter([best_epoch],np.array(test_loss_all)[best_epoch])
plt.legend()
plt.grid()
plt.savefig(f'{result_path}/try_loss.png')
plt.show()

plt.figure()
plt.plot(test_mean_acc_all,label='test mean')
plt.scatter([best_epoch],np.array(test_mean_acc_all)[best_epoch])
plt.plot(test_worst_acc_all,label='test min')
plt.scatter([best_epoch],np.array(test_worst_acc_all)[best_epoch])
plt.scatter([best_epoch],np.array(val_mean_acc_all)[best_epoch])
plt.plot(val_mean_acc_all,label='val mean')
plt.plot(val_worst_acc_all,label='val min')
plt.legend()
plt.grid()
plt.savefig(f'{result_path}/try_acc.png')
plt.show()


plt.figure()
plt.scatter(range(num_classes), dy_final,label = 'dy')
plt.scatter(range(num_classes),ly_final,label = 'ly')
plt.legend()
plt.grid()
plt.savefig(f'{result_path}/try_params_result.png')
plt.show()
from scipy.io import savemat
sort_acc = np.sort(class_wise_acc)
worst_acc = np.mean(sort_acc[0:int(num_classes*0.2)])
print('test std',np.std(class_wise_acc))
print('test mean error',1-np.mean(class_wise_acc))
print('test error',1-np.sum((class_freq*class_wise_acc)/np.sum(class_freq)))
#mdic = {'dy_w':dy_w,'ly_w':ly_w,'dy':dy,'ly':ly,'test_class_wise_acc':class_wise_acc,'test_acc':np.mean(class_wise_acc),'val_class_wise_acc':val_class_wise_acc,'val_acc':np.mean(val_class_wise_acc),'test_class_wise_acc_all':test_class_wise_acc_all}
#savemat(f'{save_path}/joint{args.joint}_earlystop{args.earlystop}_sigmoid_test{args.test_size}_freq{args.dic_freq}_error{args.dic_error}_norm{args.dic_norm}_noise{args.dic_noise}_dy{args.dy}_ly{args.ly}/post_hoc_result.mat',mdic)
print(best_test_acc,1-best_test_acc,best_val_acc,best_epoch)
logfile=open(f'{result_path}/logs.txt',mode='w')
#text=f'dy_w:{best_dy_w}\nly_w:{best_ly_w}\ndy:{best_dy}\nly:{best_ly}\ntest_class_wise_acc:{class_wise_acc.tolist()}\ntest_acc:{np.mean(class_wise_acc)}\nval_acc:{val_acc}\n'
text=f'dy:{dy_final}\nly:{ly_final}\ntest_class_wise_acc:{class_wise_acc.tolist()}\ntest_mean_acc:{np.mean(class_wise_acc)}\ntest_std_acc:{1-np.sum((class_freq*class_wise_acc)/np.sum(class_freq))}\nbest_test_acc:{best_test_acc}\nbest_epoch:{best_epoch}\nbest_val_acc:{best_val_acc}\ntest_error:{1-np.mean(best_test_acc)}\ntime:{end_time-start_time}\ntest_std:{np.std(class_wise_acc).tolist()}\nfew_acc:{np.mean(class_wise_acc[-int(0.2*num_classes):-1]).tolist()}\nworst_acc:{np.mean(sorted(class_wise_acc)[0:int(0.2*num_classes)]).tolist()}\n'
logfile.write(text)

#python train_posthoc_order1_v4_joint.py --noisy True --test_size 50 --runs 1_5000_imbalance --dic_freq True 