<!---
Copyright 2020 The HuggingFace Team. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Text classification examples

## GLUE tasks

Based on the script [`run_glue.py`](https://github.com/huggingface/transformers/blob/main/examples/pytorch/text-classification/run_glue.py).

``` Random and Magnitue
export TASK_NAME=mnli

python run_glue_mag.py \
  --model_name_or_path bert-base-uncased \
  --task_name $TASK_NAME \
  --prune mag \
  --prune-ratio 0.8 \
  --num-exp 3 \
  --output_dir /tmp/$TASK_NAME/
```
``` IMP
python run_glue_imp.py \
  --model_name_or_path bert-base-uncased \
  --task_name $TASK_NAME \
  --prune-ratio 0.8 \
  --num-exp 3 \
  --output_dir /tmp/$TASK_NAME/
```
``` GMP
python run_glue_fgmp.py \
  --model_name_or_path bert-base-uncased \
  --task_name $TASK_NAME \
  --prune-ratio 0.8 \
  --num-exp 3 \
  --output_dir /tmp/$TASK_NAME/
```
