# Vision classification examples

## Vision tasks

Based on the script [`train.py`](https://github.com/pytorch/vision/tree/main/references/classification/train.py).

``` Random, Magnitue, SNIP, GraSP, SynFlow, and ProsPr
TASK_NAME=caltech

torchrun --nproc_per_node=4 train.py \
		--model resnet50 \
        --weights ResNet50_Weights.IMAGENET1K_V1 \
		--prune mag \
        --prune-ratios 0.99 \
        --num-exp 3 \
        --data-path /DATA/$TASK_NAME \
        --batch-size 64 \
        --lr-scheduler cosineannealinglr \
        --iterations 20000 \
        --workers 4 \
        --output-dir ./mag/$TASK_NAME
```
``` IMP
torchrun --nproc_per_node=4 train_imp.py \
		--model resnet50 \
        --weights ResNet50_Weights.IMAGENET1K_V1 \
        --num-exp 3 \
        --data-path /DATA/$TASK_NAME \
        --batch-size 64 \
        --lr-scheduler cosineannealinglr \
        --iterations 20000 \
        --workers 4 \
		--start-replay 0 \
        --prune-ratio 0.99 \
        --output-dir ./imp/$TASK_NAME
```
``` GMP
torchrun --rdzv_backend=c10d --rdzv_endpoint=localhost:0 --nnodes=1 --nproc_per_node=4 train_gmp.py \
		--model resnet50 \
        --weights ResNet50_Weights.IMAGENET1K_V1 \
        --num-exp 3 \
        --data-path /DATA/$TASK_NAME \
        --batch-size 64 \
        --lr-scheduler cosineannealinglr \
        --iterations 20000 \
        --workers 4 \
		--get-mask \
        --prune-ratio 0.99 \
		--prune-end-it 10000 \
        --output-dir ./fgmp/$TASK_NAME
```
