# utils/global_vars.py

from utils.token_logger import TokenCaptureLoguru

# ✅ 全局 token 使用追踪器（唯一实例）
token_tracker = TokenCaptureLoguru()

# ✅ 数据集名称（修改此处切换数据）# 数据集选项（根据需要设置） [ProntoQA | ProofWriter | FOLIO | LogicalDeduction | AR-LSAT ｜ RepublicQA]
DATASET_NAME = "RepublicQA"

# Ablation 类型（设置为 "full"、"woFOL"、"woStatement" 之一）
ABLATION_TYPE = "full"

# ✅ 数据路径
DATASET_PATH = f"/home/PhilAgent/data/{DATASET_NAME}/dev.json"

# ✅ 统一输出文件路径（保存所有结果）
RESULT_DIR = f"/home/PhilAgent/result/{DATASET_NAME}"
RESULT_JSON_PATH = f"{RESULT_DIR}/{DATASET_NAME}_{ABLATION_TYPE}_result.jsonl"
# ✅ Prompt 根路径（按数据集分文件夹）
PROMPT_BASE_DIR = f"/home/PhilAgent/prompts/{DATASET_NAME}"





# ✅ 数据缓冲区（主程序加载后赋值）
dataset = None

# ✅ 当前正在处理的样本 ID（可选调试用）
current_sample_id = None
