import yaml
import sys
import os

script_dir = os.path.dirname(os.path.abspath(__file__))
project_root = os.path.dirname(script_dir)
sys.path.append('../') 

from src.seip_package.utils.data_loading import load_data

EXPERIMENT_NAME = "revs_benchmark_seed_42"
PATH_TO_REPO = "INSERT_PATH_TO_REPO/"
args = yaml.load(open(PATH_TO_REPO + f"FAULTSTOFEATURES/configs/seeding_experiment/{EXPERIMENT_NAME}.yaml", "r"), Loader=yaml.FullLoader)
train_dataloader, validation_dataloader, mean, std = load_data(train_path = "../"+ args["data"]["train_path"],
														train_ratio = args["data"]["train_ratio"],
														batchsize = args["data"]["batchsize"],
														columns_to_standardize = args["data"]["columns_to_standardize"],
														columns_to_drop = args["data"]["columns_to_drop"],
														sequence_length = args["data"]["sequence_length"],
														threshold = args["data"]["threshold"],
														threshold_value = args["data"]["threshold_value"],
														threshold_column = args["data"]["threshold_column"],
														target = args["data"]["target"],
														scaling = args["data"]["scaling"],
														seed = 42)

# export mean and std as yaml file
with open(f'scaling_info/{EXPERIMENT_NAME}_mean_std.yaml', 'w') as file:
    yaml.dump({'mean': mean, 'std': std}, file, sort_keys=False)