import re
from setuptools import setup, find_packages
import sys

if sys.version_info.major != 3:
    print('This Python is only compatible with Python 3, but you are running '
          'Python {}. The installation will likely fail.'.format(sys.version_info.major))


extras = {
    'test': [
        'filelock',
        'pytest',
        'pytest-forked',
        'atari-py',
        'matplotlib',
        'pandas'
    ],
    'mpi': [
        'mpi4py'
    ]
}

all_deps = []
for group_name in extras:
    all_deps += extras[group_name]

extras['all'] = all_deps

setup(name='aril',
      packages=find_packages(),
      install_requires=[
          'gym>=0.15.4, <0.16.0',
          'scipy',
          'tqdm',
          # To avoid showing the author, the repo of experiment tools is hidden. You can search on github for "exptools" at version v2.0
      ],
      extras_require=extras,
      description='Adversial Robust Imitation Learning',
      version='0.1')
