""" a demo script telling you how to make figure for your paper
"""
from exptools.viewing.plotter import PaperCurvePlotter

def main():
    paths = ["/mnt/f/aril-rarl/sensory-aril"]
    plotter = PaperCurvePlotter(paths,
        x_lim= (0, 300),
        y_lim= (000, int(100)),
        fig_name_shorten_level= 1,
        show_legend= False,
        one_fig_size= (3.5, 3.5),
    )
    exp_env = "Swimmer"
    # exp_env = "Hopper"
    # exp_env = "Walker"
    # exp_env = "HalfCheetah"
    # exp_env = "Ant"
    if exp_env == "HalfCheetah":
        plotter.make_plots(
            args_in_figures= {"env": ["HalfCheetah-v2",],},
            # args_in_series= {"env_kwargs.epsilon": [1.5,], "train_student": [False], "train_attacker": [True, False, "FGSM"]},
            args_in_series= {"env_kwargs.epsilon": [1.5,], "train_student": [True], "train_attacker": [True]},
            # args_in_series= {"env_kwargs.epsilon": [0.024,], "train_student": [False], "train_attacker": [True, False, "FGSM"], "env_kwargs.hacked": [True]},
            # args_in_series= {"env_kwargs.epsilon": [0.024,], "train_student": [True], "train_attacker": [True], "env_kwargs.hacked": [True]},
            x_key= None,
            y_key= "attacked_env_return/Average",
            xlabel= "iterations",
            ylabel= "reward",
        )
    elif exp_env == "Swimmer":
        plotter.make_plots(
            args_in_figures= {"env": ["Swimmer-v2",],},
            # args_in_series= {"env_kwargs.epsilon": [0.25,], "train_student": [False], "train_attacker": [True, False, "FGSM"]},
            args_in_series= {"env_kwargs.epsilon": [0.25,], "train_student": [True], "train_attacker": [True]},
            # args_in_series= {"env_kwargs.epsilon": [0.014,], "train_student": [False], "train_attacker": [True, False, "FGSM"], "env_kwargs.hacked": [True]},
            # args_in_series= {"env_kwargs.epsilon": [0.014,], "train_student": [True], "train_attacker": [True], "env_kwargs.hacked": [True]},
            x_key= None,
            y_key= "attacked_env_return/Average",
            xlabel= "iterations",
            ylabel= "reward",
        )
    elif exp_env == "Walker":
        plotter.make_plots(
            args_in_figures= {"env": ["Walker2d-v2",],},
            args_in_series= {"env_kwargs.epsilon": [0.25,], "train_student": [True, False]},
            x_key= None,
            y_key= "attacked_env_return/Average",
            xlabel= "iterations",
            ylabel= "reward",
        )
    elif exp_env == "Ant":
        plotter.make_plots(
            args_in_figures= {"env": ["Ant-v2",],},
            # args_in_series= {"env_kwargs.epsilon": [0.5,], "train_student": [False], "train_attacker": [True, False, "FGSM"]},
            args_in_series= {"env_kwargs.epsilon": [0.5,], "train_student": [True], "train_attacker": [True]},
            # args_in_series= {"env_kwargs.epsilon": [0.01,], "train_student": [False], "train_attacker": [True, False, "FGSM"], "env_kwargs.hacked": [True]},
            # args_in_series= {"env_kwargs.epsilon": [0.01,], "train_student": [True], "train_attacker": [True], "env_kwargs.hacked": [True]},
            x_key= None,
            y_key= "attacked_env_return/Average",
            xlabel= "iterations",
            ylabel= "reward",
        )


if __name__ == "__main__":
	main()
