# import all algorithms this benchmark implement

def call_algo(algo_name, config, mode, device):
    if mode == 'online-online':
        algo_name = algo_name.lower()
        assert algo_name in ['sac', 'darc', 'vgdf', 'sac_iw', 'par', 'dadiff_modify', 'dadiff_select', 'daflow_modify']
        # online online setting
        # from online_online.darc import DARC
        # from online_online.sac import SAC
        # from online_online.vgdf import VGDF
        # from online_online.sac_iw import SAC_IW
        # from online_online.par import PAR
        from algo.online_online.dadiff_modify import DADiff as DADiff_modify
        from algo.online_online.dadiff_select import DADiff as DADiff_select
        from algo.online_online.daflow_modify import DAFlow as DAFlow_modify

        algo_to_call = {
            # 'sac': SAC,
            # 'darc': DARC,
            # 'vgdf': VGDF,
            # 'sac_iw': SAC_IW,
            # 'par': PAR,
            'dadiff_modify': DADiff_modify,
            'dadiff_select': DADiff_select,
            'daflow_modify': DAFlow_modify,
        }

        algo = algo_to_call[algo_name]
        policy = algo(config, device)

    elif mode == 'offline-offline':
        return
        algo_name = algo_name.lower()
        assert algo_name in ['dara', 'bosa', 'iql', 'td3_bc', 'igdf']
        # offline offline setting
        from offline_offline.dara import DARA
        from offline_offline.bosa import BOSA
        from offline_offline.iql import IQL
        from offline_offline.td3_bc import TD3BC
        from offline_offline.igdf import IGDF

        algo_to_call = {
            'dara': DARA,
            'bosa': BOSA,
            'iql': IQL,
            'td3_bc': TD3BC,
            'igdf': IGDF,
        }

        algo = algo_to_call[algo_name]
        policy = algo(config, device)
    
    return policy