#!/usr/bin/env bash

mkdir -p output

# train from scratch, and model is saved under "projdir"

python -u train_central_cluster.py --projdir "output/10cli_3cluster_central_cluster"  
python -u train_cluster_mnist_single.py   --projdir "output/10cli_3cluster_fedavg" 
python -u train_EM_update_all.py  --projdir "output/10cli_3cluster_EM_all"
python -u train_cluster_mnist_qffl.py --projdir "output/10cli_3cluster_qffl_q1"  --q 1
python -u train_cluster_mnist_afl.py --projdir "output/10cli_3cluster_afl_llr0.01"  --learning_rate_lambda 0.01 
python -u train_cluster_mnist_fedprox.py --projdir "output/10cli_3cluster_fedprox_mu1"  --mu 1

# train from the checkpoint under "projdir" (the new model will rewrite the old model under "projdir")
python -u train_cluster_mnist_single.py   --projdir "output/10cli_3cluster_fedavg" --checkpoint 1 
python -u train_central_cluster.py --projdir "output/10cli_3cluster_central_cluster"  --checkpoint 1
python -u train_EM_update_all.py  --projdir "output/10cli_3cluster_EM_all"  --checkpoint 1
python -u train_cluster_mnist_qffl.py --projdir "output/10cli_3cluster_qffl_q1"  --q 1 --checkpoint 1
python -u train_cluster_mnist_afl.py --projdir "output/10cli_3cluster_afl_llr0.01"  --learning_rate_lambda 0.01 --checkpoint 1
python -u train_cluster_mnist_fedprox.py --projdir "output/10cli_3cluster_fedprox_mu1"  --mu 1 --checkpoint 1



# inference: to get the local test acc statistics, which will be saved to "projdir"
python -u train_cluster_mnist_single.py   --projdir "output/10cli_3cluster_fedavg" --checkpoint 1   --inference-mode 1 
python -u train_central_cluster.py --projdir "output/10cli_3cluster_central_cluster"  --checkpoint 1 --inference-mode 1 
python -u train_EM_update_all.py  --projdir "output/10cli_3cluster_EM_all"  --checkpoint 1 --inference-mode 1 
python -u train_cluster_mnist_qffl.py --projdir "output/10cli_3cluster_qffl_q1"  --q 1 --checkpoint 1 --inference-mode 1
python -u train_cluster_mnist_afl.py --projdir "output/10cli_3cluster_afl_llr0.01"  --learning_rate_lambda 0.01 --checkpoint 1 --inference-mode 1
python -u train_cluster_mnist_fedprox.py --projdir "output/10cli_3cluster_fedprox_mu1"  --mu 1 --checkpoint 1 --inference-mode 1
