# FOCUS 

Implementation of FOCUS, experiments with four datasets.

## Requirements
* Python3
* Pytorch
* Numpy

## Config.json
```json
    "m" : 10,               # number of training clients (used for splitting the train dataset and setting the number of clients)
    "m_test" : 10,        # number of test clients (used for splitting the test dataset) which is the same as the number of training clients 
    "p" : 2,               # number of cluster groups 
    "per_cluster_list":[[0,1,2,3,4,5,6],[7,8,9]]    # partition the clients into number of cluster groups 
    "num_epochs": 300,     # number of epochs
    "batch_size":100,      # batch size of local update
    "tau":10,              # number of local epochs in worker machines
    "lr":0.1,              # learning rate
    "data_seed":0,         # random seed for generating data
    "train_seed":0         # random seed for weight initiailization and training

```

## Running the experiments


### To reproduce results on synthetic data
```bash
cd synthetic
bash run.sh
```

### To reproduce results on MNIST
```bash
cd mnist
bash run.sh
```


### To reproduce results on CIFAR
```bash
cd cifar-rotate
bash run.sh 
```

### To reproduce results on Yelp/IMDB
```bash
cd bert
bash run.sh 
```
It will run all the experiments (centralized cluster model, fedavg, FOCUS).
