#!/usr/bin/env bash

# export OMP_NUM_THREADS=4

mkdir -p output

python -u train_cluster_central_cifar.py  --projdir "output/central"
python -u train_cluster_cifar_single.py --projdir "output/fedavg"
python -u train_EM_update_all.py --projdir "output/focus"
python -u train_cluster_cifar_qffl.py --projdir "output/qffl_q1"  --q 1
python -u train_cluster_cifar_afl.py --projdir "output/afl_llr0.01"  --learning_rate_lambda 0.01 
python -u train_cluster_cifar_fedprox.py --projdir "output/fedprox_mu1"  --mu 1

python -u train_cluster_central_cifar.py  --projdir "output/central" --inference-mode 1 --checkpoint 1
python -u train_cluster_cifar_single.py --projdir "output/fedavg" --inference-mode 1 --checkpoint 1
python -u train_EM_update_all.py --projdir "output/focus" --inference-mode 1 --checkpoint 1
python -u train_cluster_cifar_qffl.py --projdir "output/qffl_q1"  --q 1 --inference-mode 1 --checkpoint 1
python -u train_cluster_cifar_afl.py --projdir "output/afl_llr0.01"  --learning_rate_lambda 0.01 --inference-mode 1 --checkpoint 1
python -u train_cluster_cifar_fedprox.py --projdir "output/fedprox_mu1"  --mu 1 --inference-mode 1 --checkpoint 1