%% Compute bounds from SDP
clear
clc
NetDataPath=[pwd '\data\net_data__19.07.txt'];
NetDataPath=[pwd '\data\net_data_2x500.txt'];
fileID = fopen( NetDataPath, 'r');
json_text = fread(fileID, '*char').';
fclose(fileID);

% decoding JSON
data = jsondecode(json_text);
A=data.A;
b=data.b;

fileID = fopen('img_test_data.txt', 'r');
json_text = fread(fileID, '*char').';
fclose(fileID);
Img_data = jsondecode(json_text);
X=Img_data.img;
Train_Label=Img_data.img_lb;


eps_tol=0.5/255
% When eps_tol is too small, all of the nodes may be deterministic, implying that the network is robust. 
for i=1:length(A)
    A_nv=A{i};
    A_nv=vecnorm(A_nv,inf,2);
    A_nv=1./A_nv;
    A{i}=diag(A_nv)*A{i};
    b{i}=diag(A_nv)*b{i};
end


for Img_index=1:100
    disp(Img_index)
    x=X(Img_index,:);
    x0=x(:);
    bias=b;

    W=A;
    W(end)=[];
    bias(end)=[];
    [~,o]=RunBNN(W,bias,x0);
    y=A{end}*o{end}+b{end};


    [~,y_order]=sort(y,'descend');
    T_label=y_order(1);
    Att_label=y_order(2);
    % Att_label=1;
    f=A{end}(T_label,:)-A{end}(Att_label,:);
    Robust_bound=b{end}(T_label)-b{end}(Att_label,:);




    L=max(x0-eps_tol,-1);
    U=min(x0+eps_tol,1);
    Bound_L=-1+0*x0;
    Bound_U=1+0*x0;

    f=double(f);





    [As,bs,fs,cs,Index_pos,Index_neg]=Prob2std_prob(W,bias,L,U,f);


    for i=1:length(As)
        Ap{i}=double(As{i});

    end


    for i=1:length(bs)
        bp{i}=double(bs{i});
        Bound_L=[Bound_L;-1*ones(size(bp{i},1),1)];
        Bound_U=[Bound_U;1*ones(size(bp{i},1),1)];
    end

    obj_F=fs;
    obj_F=double(obj_F);


    imshow(reshape(x0,[28,28]))
    disp('T_label=')
    disp(T_label)



    if ((1+Train_Label(Img_index))~=T_label)
        disp('Wrong Classification')
        continue
    end
    pause(1e-5);


    % Ap


    % disp([cs+Robust_bound])   % cs: deterministic nodes from the Last hidden layer that are added to the bias from the obj_f



    [fval(Img_index),xp,fp,intcon,Mp,vp,time(Img_index),output{Img_index}]=Grb_sof_Fesiable(Ap,bp,obj_F,Bound_L,Bound_U,1e-7,cs+Robust_bound);
    % fval

    % time
end

