function [As,bs,fs,cs,Index_pos,Index_neg]=Prob2std_prob(A,b,L,U,f)

% convert Problem from: 
%      min dot(f,x{end})
% s.t. x{i+1}=sign(A{i}*x{i}+b{i}) ,i=1,2,3...L
%       L<= x{1} <=U
%  to std problem:
%      min dot(fs,xs{end})+cs
% s.t. x{i+1}=sign(A{i}*x{i}+b{i}),i=1,2,3...L
%       -1<= x{1} <=1
% Last_hidden_layer is the result of Last hidden layer, i.e.
% Last_hidden_layer(i)=1 iff 


% with ||A{i}(k,:)||_1>= b{i}(k) for all i,k


 [Ap,bp,Index_pos,Index_neg]=BNN_preprocessing(A,b,L,U);
 [As,bs,fs,cs]=BNN_verify_preprocessing_last_layer(Ap,bp,f);
end



function [A,b,Index_pos,Index_neg]=BNN_preprocessing(A,b,L,U)
% For any Matrix cells A, vector cells b, vector L,U we consider the
% following Network:
% L<=x{0}<=U
% x{i+1}=sign(A{i}*x{i}+b{i})
% we rewrite it as
% L=-1, U=1;
% A{i}(k,:)=0 if |b{i}|>norm(A{i}(k,:),1)
% norm_inf(A{i}(:))=1


%% A{i},b{i} normailze


num_layers=length(A);
num_layers=num_layers+1; %length of layers (including input layer but not including output layer)
n=size(A{1},2);

for i=1:length(b)
    n(end+1)=length(b{i});
end
N=sum(n); %num of all of nodes (input+hidden layers)
Bound_L=ones(N,1)*(-1);
Bound_U=-1*Bound_L;

%input encoding

% for input L<x<U, adjust t \in [-1,1], t= x0+t*eps with x0=(L+U)/2 eps=U-L
L=L(:);
U=U(:);
x0=(L+U)/2;
eps=(U-L)/2;
b{1}=A{1}*x0+b{1};
% A*(d.*t)==(d.').*A*t
A{1}=(eps(:).').*A{1};

Norm_A_inf=norm(A{1}(:),inf);
A{1}=1/Norm_A_inf *A{1};
b{1}=1/Norm_A_inf *b{1};
% h_1=sign(A*t+b), t\ in [-1,1]^n, A\in [-1,1]^{n_2*n_1}

 
%% Detect the nodes which always activated/ unactivated


% if ||A{i}(k,:)||_1<|b{i}(k)| then:
 

N_index=cumsum(n);
for i=(1):(length(A)-1)

    z=nv(A{i});
    Index_pos{i}=find(b{i}>z);
    Index_neg{i}=find(b{i}<-z);
    num_pos=length(Index_pos{i});
    num_neg=length(Index_neg{i});
    b{i+1}= b{i+1}+ A{i+1}(:,Index_pos{i})*ones(num_pos,1);
    b{i+1}= b{i+1}- A{i+1}(:,Index_neg{i})*ones(num_neg,1);
    A{i+1}(:,[Index_neg{i};Index_pos{i}])=[];
    A{i}([Index_neg{i};Index_pos{i}],:)=[];
    b{i}([Index_pos{i};Index_neg{i}],:)=[];
 

end




end

function [A,b,f,c]=BNN_verify_preprocessing_last_layer(A,b,f)

% input:
% A,b: std BNN verificiation prob with input -1<=x<=1
% f: obj function (linear)

% output:
% A,b: std BNN verificiation prob with input -1<=x<=1
% new output obj function is <x_new,f_new>+c
% with A{end}, b{end} be standardized

i=length(b);
z=nv(A{i});
Index_pos=find(b{i}>z);
Index_neg=find(b{i}<-z);
num_pos=length(Index_pos);
num_neg=length(Index_neg);
A{i}([Index_neg;Index_pos],:)=[];
b{i}([Index_pos;Index_neg],:)=[];
 
v=f*0;
v(Index_neg)=-1;
v(Index_pos)=1;
c=dot(f,v);


f([Index_neg;Index_pos])=[];
end


function z=nv(A)
z=vecnorm(A,1,2);
end