function BNNV2POP_Large(A,b,F,options)
% For large A and b , using readdlm instead
% input: std BNN verification problem with matrix cell A and vector cell b
% and linear obj function F.
% options :
% options.norm=inf(default)  or 2
% options.type='tighter' (default)  or  'QCQP+LP'
% options.solver= 'Mosek'(default)  or  'COSMO'
% options.sparsity = 'TSSOS'(default)  or  'CSTSSOS'
% [1:N(2)],[N(1):N(3)],...,[N(end-2):N(end)]
% options.order=integer (default=1).  

%options.Lb, options.Ub (only for L2-norm with options.type='tighter'): Bound of  each input node, i.e. options.Lb<=x{input}<=options.Ub 


% % output:
% BNNV2POP.jl which using TSSOS to solve POP porblem

if nargin==3
options.norm=inf;
options.type='tighter';
options.solver= 'Mosek';
options.sparsity = 'TSSOS';
options.clique = 'MF';
options.order=1;
end

d=options.order;

L=length(b);
% x{k+1}=sign(A{k}*x{k}+b{k})
% x{k+1}(A{k}x{k}-b{k})>=0
% network strcutre: len([x;h1;h2;h3;...;hL;o ])=N
N=size(A{1},2);
for i=1:length(A)
    N(end+1)=size(A{i},1);
end

T{1}='using TSSOS';
T{2}='using DynamicPolynomials';
T{end+1}='using DelimitedFiles';

T{end+1}=['n=' num2str(N(1))];
T{1+end}=['@polyvar x' num2str(0) '[1:n]'];
T{end+1}=['var=x0[1:2]'];
for i=1:L
    T{end+1}=['n=' num2str(N(i+1))];
    T{end+1}=['@polyvar x' num2str(i) '[1:n];'];
    T{end+1}=['var=[var;x' num2str(i) '];'];
end
T{end+1}=['G=[x0[1]+1.2];'];
T{end+1}=['var=var[3:end];'];
T{end+1}=['NumBVar=length(var);'];
T{end+1}=['var=[var;x0];'];


%% input encoding

% L_inf
if(options.norm==inf)
    x0=zeros(size(A{1},2),1);
    vareps=1;
    T{end+1}=['x_0=' Mat2str(0*x0(:))];
    T{end+1}=['vareps=' num2str(vareps)];
    % T{end+1}=['G=[G;x0-x_0.+vareps;x_0.+vareps-x0];'] ;
    T{end+1}=['G=[G;(x0-x_0.+vareps).*(x_0.+vareps-x0)];'] ;
end

% L_2
if(options.norm==2)
    %x0>=x_0.-vareps ; x_0.+vareps>=x0
    % T{end+1}=['G=[G;1-sum(x0.^2)];'] ;
    x0=zeros(size(A{1},2),1);
    T{end+1}=['G=[G; 1-sum(x0.*x0)];'] ;
end

%% Add Lb-Ub bounds
% add in 2024.5.8
if isfield(options,'Lb')
    Bound_L=options.Lb;
    Bound_U=options.Ub;
    T{end+1}=['Bound_U=' Mat2str(Bound_U)];
    T{end+1}=['Bound_L=' Mat2str(Bound_L)];
    T{end+1}=['G=[G;(Bound_U.-x0).*(x0.-Bound_L)];'] ;
end

%% BNN encoding

% Add _ str_index 
% Save \tmp\str_index.log as the str_index-th data



str_index=0;
% % \tau_tighter
if strcmp(options.type,'tighter')
    for i=1:L
        command=MatlabWriteFile(A{i},num2str(str_index));
        T{end+1}=['A=' command ];
        str_index=str_index+1;



        command=MatlabWriteFile(b{i},num2str(str_index));
        T{end+1}=['b=' command ];
        str_index=str_index+1;



        T{end+1}=['xt=x'  num2str(i-1) ';'];
        T{end+1}=['yt=x'  num2str(i) ';'];
        T{end+1}=['G=[G;(yt.+1).*(A*xt+b)];'];
        T{end+1}=['G=[G;(yt.-1).*(A*xt+b)];'];
        A_nv=A{i};


        A_nv=vecnorm(A_nv,1,2);


        command=MatlabWriteFile(A_nv,num2str(str_index));
        T{end+1}=['A_norm=' command ];
        str_index=str_index+1;


        T{end+1}=['G=[G;-1*(yt.-1).*(A_norm.+A*xt)];'];
        T{end+1}=['G=[G;(yt.+1).*(A_norm.-A*xt)];'];

    end
end


% % \tau_{QCQP+LP}
if strcmp(options.type,'QCQP+LP')
    for i=1:L
        Upperbound=vecnorm(A{i},1,2)+b{i};
        Lowerbound=-vecnorm(A{i},1,2)+b{i};
        strU=Mat2str(Upperbound);
        strL=Mat2str(Lowerbound);
        T{end+1}=['Upperbound=' strU ';'];
        T{end+1}=['Lowerbound=' strL ';'];
        str=Mat2str(A{i});
        T{end+1}=['A=' str ';'];
        str=Mat2str(b{i});
        T{end+1}=['b=' str ';'];
        T{end+1}=['xt=x'  num2str(i-1) ';'];
        T{end+1}=['yt=x'  num2str(i) ';'];
        T{end+1}=['G=[G;yt-2*(A*xt+b)./Upperbound.+1];'];
        T{end+1}=['G=[G;-2*(A*xt+b)./Lowerbound-yt.+1];'];
        T{end+1}=['G=[G;yt.*(A*xt+b)];'];
    end
end
% % \tau_{QCQP}
if strcmp(options.type,'QCQP')
    for i=1:L
        str=Mat2str(A{i});
        T{end+1}=['A=' str ';'];
        str=Mat2str(b{i});
        T{end+1}=['b=' str ';'];
        T{end+1}=['xt=x'  num2str(i-1) ';'];
        T{end+1}=['yt=x'  num2str(i) ';'];
        T{end+1}=['G=[G;yt.*(A*xt+b)];'];
    end
end




%% obj Function enconding

if length(F)==2
    objA=F{1};
    objf=F{2};
else
    objA=0;
    objf=F{1};
end
T{end+1}=['oA=' Mat2str(objA)];
T{end+1}=['of=' Mat2str(objf(:).')];
T{end+1}=['objF=1/2*transpose(yt)*oA*yt+of*yt'  ';'];
T{end+1}='G[1]=objF[1];';


%% TSSOS start
% Change this line to change relaxation order %
T{end+1}=['d=' num2str(d) ';'];

% options.solver= 'Mosek';
% options.sparsity = 'TSSOS';
% options.clique = 'MF';
% options.order=1;

if strcmp(options.sparsity,'TSSOS')
    T{end+1}=['opt,sol,data = tssos_first(G, var, d, TS="MD",nb=NumBVar,solver="', options.solver, '");'];
end

if strcmp(options.sparsity,'CSTSSOS')
    T{end+1}='NN=length(var)';
    T{end+1}='@polyvar x_Vars[1:NN]';
    T{end+1}='G_true=subs(G,var=>x_Vars);';
    % opt,sol,data = cs_tssos_first(G_true,x_Vars, d, TS="MD",nb=NumBVar,solver="COSMO");
    if strcmp( options.clique,'NN')
         [C,str]=Clique_collect(N);
         T{end+1}=['clique_list=' str ';'];
         T{end+1}=' Clique_List=[vec(clique_list[1])];for i=2:length(clique_list);push!(Clique_List,vec(clique_list[i]));end';
        T{end+1}=['opt,sol,data = cs_tssos_first(G_true,x_Vars, d, TS="MD",nb=NumBVar,cliques=Clique_List,solver="', options.solver, '");'];
    else
        T{end+1}=['opt,sol,data = cs_tssos_first(G_true,x_Vars, d, TS=false,nb=NumBVar,solver="', options.solver, '");'];
    end
end
%% Write .jl File
fileID = fopen('JuliaCode.jl','w');
for i=1:length(T)
    fprintf(fileID,T{i});
    fprintf(fileID,'\n');
end
fclose(fileID);
end

function str=Mat2str(A)
% matlab matrix-> julia form matrix data
str=mat2str(A);
return
str='[';
for i=1:size(A,1)
    str=[str, num2str(A(i,:)), ';'];
end
str=[str,']'];
end


function [C,str]=Clique_collect(n)

% Note: the sort of Var is [x[1],x[2],x[3],...,x[L],x[0]]!
CN=cumsum(n);
for i=1:length(n)-1

    if i==1
        C{i}=[1:CN(2)];
    else
        C{i}=[(CN(i-1)+1):CN(i+1)];
    end
end


Index_swap=1:sum(n);
Index_swap(1:n(1))=[];
Index_swap=[ Index_swap ,(1:n(1))];
[~,Index_swap_map]=sort(Index_swap);

for i=1:length(C)
    C{i}=sort(Index_swap_map(C{i}));
end

str='[';
for i=1:length(C)
    str=[str,mat2str(C{i}) ','];
end
str=[str,'];'];
end



function command=MatlabWriteFile(A,name)


%Wrtie Code For julia and Matlab 
% e.g. name=A.txt
% then command will be readdlm（A.txt)
% which can run in julia to get the data
fileID = fopen(name,'w');
B=num2str(A,16);
for i=1:size(B,1)
    fprintf(fileID,B(i,:));
    fprintf(fileID,'\n');
end
fclose(fileID);

command=['readdlm("' name '");'];
end