function [Lambda,f,M,v,Index_of_dual_LP_sign_Lower_Bound,Index_of_dual_LP_sign_Upper_Bound,Index_of_dual_LP_binary_Lower_Bound,Index_of_dual_LP_binary_Upper_Bound]=Dual_LP_BNN(A,b,obj_f,Bound_L,Bound_U)
% input: matrix cell A={A0,A1,A2,...,A_L,A_{L+1}}, vector cell b={b1,b2,b3,...,b_L,b_{L+1}}
% Bound_L,Bound_U: vectors such that U<=x_input<=L after BNN_verify_preprocessing
% running of BNN  x_{i+1}=sign(A_i*x_i+b_i)
% obj_f: vector, means the obj function of LP is min <obj_F,x{end}> s.t. ...

% output: solution of dual problem




num_layers=length(A);
num_layers=num_layers+1; %length of layers (including input layer but not including output layer)
n=size(A{1},2);

for i=1:length(b)
    n(end+1)=length(b{i});
end



num_all_nodes=sum(n);%num of all of nodes (input+hidden layers)
Index=cumsum(n);



%objfunction encoding

f=zeros(1,num_all_nodes);
f(Index(end-1)+1:Index(end))=obj_f;



% sign encoding
% M_sign_L{i}*[x{i};x{i+1}]<=v_sign_L{i} <--> x{i+1}>=2/(n+b)*(wx+b)-1 <-->2/(n+b)*(wx+b)-1 -x{i+1}<=0
% M_sign_U{i}*[x{i};x{i+1}]<=v_sign_U{i}  


M=[];
v=[];
Index_of_dual_LP_sign_Upper_Bound={};
Index_of_dual_LP_sign_Lower_Bound={};
Index_of_dual_LP_binary_Upper_Bound=[];
Index_of_dual_LP_binary_Lower_Bound=[];
for i=2:length(n)

    A_temp=A{i-1};
    b_temp=b{i-1};
    [M_sign_L{i},M_sign_U{i},v_sign_L{i},v_sign_U{i}]=Generate_Sign_bound_Matrix(A_temp,b_temp);
    z=IndexofZerorows(A_temp);
    
    M_sign_L{i}(z,:)=0;
    M_sign_U{i}(z,:)=0;
    v_sign_L{i}(z)=0;
    v_sign_U{i}(z)=0;
    if i==2
        Lx=1;
    else
        Lx=Index(i-2)+1;
    end
    Ly=Index(i);
    Ed_M=size(M,1)+1;
    Index_of_dual_LP_sign_Lower_Bound{i}=Ed_M:(Ed_M+n(i)-1);
    Index_of_dual_LP_sign_Upper_Bound{i}=(Ed_M+n(i)):(Ed_M+2*n(i)-1);
    M(Ed_M:(Ed_M+n(i)-1),Lx:Ly)=M_sign_L{i};
    Ed_M=size(M,1)+1;
    M(Ed_M:(Ed_M+n(i)-1),Lx:Ly)=M_sign_U{i};
    v=[v;v_sign_L{i};v_sign_U{i}];

end


M=[M;eye(num_all_nodes);-1*eye(num_all_nodes)];
Index_of_dual_LP_binary_Upper_Bound=(length(v)+1):(length(v)+length(Bound_U));
Index_of_dual_LP_binary_Lower_Bound=(length(v)+length(Bound_U)+1):(length(v)+length(Bound_U)*2);
v=[v;Bound_U;-Bound_L];
% d=linprog(f,M,v,[],[],Bound_L,Bound_U); %  X = linprog(f,A,b,Aeq,beq,LB,UB) 



Lambda=linprog(v,-eye(size(M,1)),zeros(1,size(M,1)),M',-f);% Dual problem
% %% Test part
% % d=linprog(f,M,v); %  X = linprog(f,A,b,Aeq,beq,LB,UB) 
% % gap=dot(l,-v)-dot(d,f);


end

function [M_sign_L,M_sign_U,v_sign_L,v_sign_U]=Generate_Sign_bound_Matrix(W,t)
% input : Matrix  W, vector t such that y=sign(W*x+t) 

% output Matrix A, vector b such that A*[x;y]<=b
L_inf=norm(W(:),inf);

% W=W/L_inf;
% t=t/L_inf;
ny=size(W,1);
n=size(W,2); %num of x
E_y=eye(ny);

% y>=2(A{i}x{i}+b{i})/(n+b{i})
t=t(:);

M_sign_L=[2./(n+t).*W,-E_y];
v_sign_L=1-2./(n+t).*t;

M_sign_U=[-2./(n-t).*W,E_y];
v_sign_U= 2./(n-t).*t+1;
end


function z=IndexofZerorows(A)

z=all(not(A'));
end