%% Compute bounds from SDP  
clear
clc

NetDataPath = [pwd '\data\net_data_2x500.txt'];
% NetDataPath=[pwd '\data\net_data__19.07.txt'];
 fileID = fopen( NetDataPath, 'r');
json_text = fread(fileID, '*char').';
fclose(fileID);
% decoding JSON 
data = jsondecode(json_text);
A=data.A;

b=data.b;

eps_tol=2/255;
% When eps_tol is too small, all of the nodes may be deterministic, implying that the network is robust. 

fileID = fopen('img_test_data.txt', 'r');
json_text = fread(fileID, '*char').';
fclose(fileID);
Img_data = jsondecode(json_text);
X=Img_data.img;
Train_Label=Img_data.img_lb;

for i=1:length(A)
    A_nv=A{i};
    A_nv=vecnorm(A_nv,inf,2);
    A_nv=1./A_nv;
    A{i}=diag(A_nv)*A{i};
    b{i}=diag(A_nv)*b{i};
end


for Img_index=1:2

    x=X(Img_index,:);
    x0=x(:);



    bias=b;

    W=A;
    W(end)=[];
    bias(end)=[];
    [~,o]=RunBNN(W,bias,x0);
    y=A{end}*o{end}+b{end};


    [~,y_order]=sort(y,'descend');
    T_label=y_order(1);
    Att_label=y_order(2);
    % Att_label=1;
    f=A{end}(T_label,:)-A{end}(Att_label,:);
    Robust_bound=b{end}(T_label)-b{end}(Att_label,:);




    L=max(x0-eps_tol,-1);
    U=min(x0+eps_tol,1);
    Bound_L=-1+0*x0;
    Bound_U=1+0*x0;

    f=double(f);





    [As,bs,fs,cs,Index_pos,Index_neg]=Prob2std_prob(W,bias,L,U,f);


    for i=1:length(As)
        Ap{i}=double(As{i});

    end


    for i=1:length(bs)
        bp{i}=double(bs{i});
        Bound_L=[Bound_L;-1*ones(size(bp{i},1),1)];
        Bound_U=[Bound_U;1*ones(size(bp{i},1),1)];
    end

    obj_F=fs;
    obj_F=double(obj_F);


    imshow(reshape(x0,[28,28]))
    disp('T_label=')
    disp(T_label)



    if ((1+Train_Label(Img_index))~=T_label)
        disp('Wrong Classification')
        continue
    end
    pause(1e-5);

    % Ap
    % disp([cs+Robust_bound])   % cs: deterministic nodes from the Last hidden layer that are added to the bias from the obj_f

    ooptions=BNNVoptions();
    options.norm=inf;
    options.type='tighter';
    options.solver= 'Mosek';
    options.sparsity = 'CSTSSOS';
    options.clique = 'CM';
    options.order=1 ;
    
    % disp('BNNV2POP tighter:')
    options.type='tighter';

    try
    BNNV2POP_Large(Ap,bp,{obj_F},options);
    diary('BNNV_output.log')
    system(['julia JuliaCode.jl'] ,'-echo');
    diary off
    [opt_sdp(Img_index),time_sdp(Img_index)]=Read_Output_of_TSSOS('BNNV_output.log');
    movefile('BNNV_output.log',['BNNV_output-Index-'  num2str(Img_index) 'eps-' num2str(eps_tol) '.log'],'f')
    catch
        opt_sdp(Img_index)=nan;
        time_sdp(Img_index)=nan;
    end
    [Lambda,fp,Mp,vp,Index_of_dual_LP_sign_Lower_Bound,Index_of_dual_LP_sign_Upper_Bound,Index_of_dual_LP_binary_Lower_Bound,Index_of_dual_LP_binary_Upper_Bound]=Dual_LP_BNN(Ap,bp,obj_F,Bound_L,Bound_U);
    tic;
    [xp,dp]=linprog(fp,Mp,vp,[],[],Bound_L,Bound_U);
    time_lp(Img_index)=toc;
    disp('LP:=')
    disp(dp);
    opt_lp(Img_index)=dp;
    opt_sdp(Img_index)=cs+Robust_bound+opt_sdp(Img_index);
    opt_lp(Img_index)=opt_lp(Img_index)+cs+Robust_bound;


end


