
function [l,u]=Fast_Lp(A,b,L,U)

% compute l,u such that 
% l<=Ax+b <=u 
% for all L<=x<+U


L=L(:);
U=U(:);

for i=1:size(b)
w=A(i,:);
t=sign(w);
t=t(:);
xl=0*w;
xl(t<0)=U(t<0);
xl(t>0)=L(t>0);


xu=0*w;
xu(t<0)=L(t<0);
xu(t>0)=U(t>0);
l(i)=dot(w,xl)+b(i);
u(i)=dot(w,xu)+b(i);
end

l=l(:);
u=u(:);
end