function [As,bs,fs,cs,Index_pos,Index_neg,bound_L,bound_U]=Prob2std_prob_l2_with_bound(A,b,x0,eps_l2,f,Lb,Ub)
% convert Problem from: 
%      min dot(f,x{end})
% s.t. x{i+1}=sign(A{i}*x{i}+b{i}) ,i=1,2,3...L
%       ||x{1}||_2<=eps_tol
%        Lb<=x{1}<=Ub
%  to std problem:
%      min dot(fs,x{end})
% s.t. x{i+1}=sign(A{i}*x{i}+b{i}),i=1,2,3...L
%          ||x{1}||_2<=1
%          bound_L<=x{1}<=bound_U
% Last_hidden_layer is the result of Last hidden layer, i.e.
% Last_hidden_layer(i)=1 iff 
% with ||A{i}(k,:)||_1>= b{i}(k) for all i,k



%% normalization

b{1}=A{1}*x0+b{1};
A{1}=eps_l2*A{1};

nvA=vecnorm(A{1},2,2); % nvA(i)=norm(A{1}(i,:))
%  Node_U_Bound{i} >=i-th hidden layer (before sign)  >= Node_L_Bound{i}


Node_L_Bound{1}=b{1}-nvA;  
Node_U_Bound{1}=b{1}+nvA;
bound_L=Lb-x0;bound_L=bound_L/eps_l2;
bound_U=Ub-x0;bound_U=bound_U/eps_l2;
[Node_L_Bound_another,Node_U_Bound_another]=Fast_Lp(A{1},b{1},bound_L,bound_U);

Node_L_Bound{1}=max(Node_L_Bound{1},Node_L_Bound_another);
Node_U_Bound{1}=min(Node_U_Bound{1},Node_U_Bound_another);

Index_pos{1}=find(Node_L_Bound{1}>0);
Index_neg{1}=find(Node_U_Bound{1}<0);

for i=1:(length(A)-1)
    After_sign_L_bound{i}=sign(Node_L_Bound{i});
    After_sign_U_bound{i}=sign(Node_U_Bound{i});
    [Node_L_Bound{i+1},Node_U_Bound{i+1}]=Fast_Lp(A{i+1},b{i+1},After_sign_L_bound{i},After_sign_U_bound{i});
end


As=A;
bs=b;
for i=1:(length(A)-1)
    Index_pos{i}=find(Node_L_Bound{i}>0);
    Index_neg{i}=find(Node_U_Bound{i}<0);


    As{i}([Index_pos{i};Index_neg{i}],:)=[];
    bs{i}([Index_pos{i};Index_neg{i}])=[];

    bs{i+1}= bs{i+1}+sum(As{i+1}(:,[Index_pos{i} ]),2)-sum(As{i+1}(:,[Index_neg{i}]),2);
    As{i+1}(:,[Index_pos{i};Index_neg{i}])=[];
     
 
end
% Last Layer
i=length(A);
Index_pos{i}=find(Node_L_Bound{i}>0);
Index_neg{i}=find(Node_U_Bound{i}<0);

As{i}([Index_pos{i};Index_neg{i}],:)=[];
bs{i}([Index_pos{i};Index_neg{i}])=[];


fs=f;
v=0*fs;
v(Index_pos{i})=1;
v(Index_neg{i})=-1;
fs(v~=0)=[];
cs=dot(v,f);
 


end


