function [M,v]=BNN2GrbLinearConds_with_bound(A,b,soft_tol,Lb,Ub)
%
%  BNN is in form of  x{i}=sign(A*x{i-1}}+b{i}) ,Lb<=x{0}<=Ub

% x{0},x{1},...,x{L} is a result of BNN iff M*(x{1};y)>=v , where x{i}=2y{i}-1


if nargin==2
    soft_tol=0;
end

n(1)=size(A{1},2);
for i=1:length(A)
    n(i+1)=size(A{i},1);
end


k=1;
for i=1:length(n)
    Layer_index{i}=k:(-1+k+n(i));
    k=k+n(i);
end


% 1st layer
i=1;

A_nv=A{i};
[A1_L,A1_U]=Fast_Lp(A_nv,zeros(size(A_nv,1),1),Lb,Ub);
A_nv=A1_U;
A_nv_vec=(2./(A_nv+b{i}));
ML=zeros(length(Layer_index{2}), sum(n));
ML(:,Layer_index{1})=-diag(A_nv_vec)*A{1};
ML(:,Layer_index{2})=eye(length(Layer_index{2}))*2;
vL=A_nv_vec.*b{1}-soft_tol;

A_nv=-A1_L;
A_nv_vec=(2./(A_nv-b{i}));
MU=zeros(length(Layer_index{2}), sum(n));
MU(:,Layer_index{1})=diag(A_nv_vec)*A{1};
MU(:,Layer_index{2})=-eye(length(Layer_index{2}))*2;
vU=-A_nv_vec.*b{1}-2-soft_tol;
M=[ML;MU];
v=[vL;vU];

% after 2nd layer


for i=2:(length(A))
    A_nv=A{i};
    A_nv=vecnorm(A_nv,1,2);
    A_nv_vec=(2./(A_nv+b{i}));
    ML=zeros(length(Layer_index{i+1}), sum(n));
    ML(:,Layer_index{i})=-2*diag(A_nv_vec)*A{i};
    ML(:,Layer_index{1+i})=2*eye(length(Layer_index{1+i}));
    vL=A_nv_vec.*b{i}-soft_tol-diag(A_nv_vec)*A{i}*ones(size(A{i},2),1);


    A_nv=A{i};
    A_nv=vecnorm(A_nv,1,2);
    A_nv_vec=(2./(A_nv-b{i}));
    MU=zeros(length(Layer_index{i+1}), sum(n));
    MU(:,Layer_index{i})=2*diag(A_nv_vec)*A{i};
    MU(:,Layer_index{1+i})=-2*eye(length(Layer_index{1+i}));
    vU=-A_nv_vec.*b{i}-2-soft_tol+diag(A_nv_vec)*A{i}*ones(size(A{i},2),1);


    M=[M;ML;MU];
    v=[v;vL;vU];
end
end