%% Generate random dense BNN with given size and run opt codes

N={[100 50 50],[200 50 50],[300 50 50],[100 50 50 50],[200 50 50 50],[300 50 50 50],[100 50 50 50 50],[200 50 50 50 50],[300 50 50 50 50]};

for Img_index=1:9
    n=N{Img_index};
    Ap={};bp={};
    for i=1:length(n)-1
        Ap{i}=sign(randn(n(i+1),n(i)));
        bp{i}=(n(i)-1)*rand(n(i+1),1).*sign(randn(n(i+1),1));
        obj_F=sign(randn(n(end),1));
    end
    A{Img_index}=Ap;
    b{Img_index}=bp;
    f_cell{Img_index}=obj_F
    %% tighter
    options=BNNVoptions();
    options.norm=inf;
    options.type='tighter';
    options.solver= 'Mosek';
    options.sparsity = 'CSTSSOS';
    options.clique = 'CM';
    options.order=1 ;
    disp('BNNV2POP tighter:')
    options.type='tighter';

    BNNV2POP_Large(Ap,bp,{obj_F},options);
    diary('BNNV_output.log')
    system(['julia JuliaCode.jl'] ,'-echo');
    diary off
    [opt_sdp(Img_index),time_sdp(Img_index)]=Read_Output_of_TSSOS('BNNV_output.log');
    movefile('BNNV_output.log',['BNNV_output-random-'  num2str(Img_index)   '.log'],'f')



    %% LP
    Bound_L=ones(sum(n),1)*(-1);
    Bound_U=ones(sum(n),1);
    fp=zeros(sum(n),1);
    fp((end+1-n(end)):end)=obj_F;
    [Lambda,fp,Mp,vp,Index_of_dual_LP_sign_Lower_Bound,Index_of_dual_LP_sign_Upper_Bound,Index_of_dual_LP_binary_Lower_Bound,Index_of_dual_LP_binary_Upper_Bound]=Dual_LP_BNN(Ap,bp,obj_F,Bound_L,Bound_U);
    tic;
    [xp,dp]=linprog(fp,Mp,vp,[],[],Bound_L,Bound_U);
    time_lp(Img_index)=toc;
    disp('LP:=')
    disp(dp);
    opt_lp(Img_index)=dp;
    opt_sdp(Img_index)=opt_sdp(Img_index);
    opt_lp(Img_index)=opt_lp(Img_index);


    %% QCQP+LP
    options=BNNVoptions();
    options.norm=inf;
    options.type='QCQP+LP';
    options.solver= 'Mosek';
    options.sparsity = 'CSTSSOS';
    options.clique = 'CM';
    options.order=1 ;
    disp('BNNV2POP QCQP+LP:')
    options.type='QCQP+LP';


    BNNV2POP_Large(Ap,bp,{obj_F},options);
    diary('BNNV_output.log')
    system(['julia JuliaCode.jl'] ,'-echo');
    diary off
    [opt_QCQPLP(Img_index),time_QCQPLP(Img_index)]=Read_Output_of_TSSOS('BNNV_output.log');
    movefile('BNNV_output.log',['BNNV_output-random-QCQPLP-'  num2str(Img_index)  '.log'],'f')




end