 N={[1000,200,200,100],[1000,100,100,100,100]}
RowSparsity=10;

%warning : it will delete files in form of 1 2 3...
for Img_index=1:length(N)
    n=N{Img_index};
    Ap={};bp={};
    for i=1:length(n)-1
%         Ap{i}=sign(randn(n(i+1),n(i)));
%         bp{i}=(n(i)-1)*rand(n(i+1),1).*sign(randn(n(i+1),1));
        [Ap{i},bp{i}]=GengerateRowSparseMatrix(n(i+1),n(i),RowSparsity);
        obj_F=sign(randn(n(end),1));
    end
    A{Img_index}=Ap;
    b{Img_index}=bp;
    f_cell{Img_index}=obj_F;
    
    
    %% tighter
    options=BNNVoptions();
    options.norm=inf;
    options.type='tighter';
    options.solver= 'Mosek';
    options.sparsity = 'CSTSSOS';
    options.clique = 'CM';
    options.order=1 ;
    disp('BNNV2POP tighter:')
    options.type='tighter';

    BNNV2POP_Large(Ap,bp,{obj_F},options);
    Dir_TempName=['Tighter-' num2str(N{Img_index}) '-s-' num2str(RowSparsity) '-Index-' num2str(Img_index)  ];
    mkdir(Dir_TempName);
    movefile('JuliaCode.jl',Dir_TempName);
    FileIndex=0;
%     JuliaCode.jl
    while exist(num2str(FileIndex),'file')
        movefile(num2str(FileIndex),Dir_TempName);
        FileIndex=FileIndex+1;
    end
    
   % pause(3)

    %QCQP
    options=BNNVoptions();
    options.norm=inf;
    options.type='QCQP';
    options.solver= 'Mosek';
    options.sparsity = 'CSTSSOS';
    options.clique = 'CM';
    options.order=1 ;
    options.type='QCQP';

    BNNV2POP_Large(Ap,bp,{obj_F},options);
    Dir_TempName=['QCQP-' num2str(N{Img_index}) '-s-' num2str(RowSparsity) '-Index-' num2str(Img_index)  ];
    mkdir(Dir_TempName);
    movefile('JuliaCode.jl',Dir_TempName);
    FileIndex=0;
%     JuliaCode.jl
    while exist(num2str(FileIndex),'file')
        movefile(num2str(FileIndex),Dir_TempName);
        FileIndex=FileIndex+1;
    end 
    
    Bound_L=ones(sum(n),1)*(-1);
    Bound_U=ones(sum(n),1);
    fp=zeros(sum(n),1);
    fp((end+1-n(end)):end)=obj_F;
    [Lambda,fp,Mp,vp,Index_of_dual_LP_sign_Lower_Bound,Index_of_dual_LP_sign_Upper_Bound,Index_of_dual_LP_binary_Lower_Bound,Index_of_dual_LP_binary_Upper_Bound]=Dual_LP_BNN(Ap,bp,obj_F,Bound_L,Bound_U);
    tic;
    [xp,dp]=linprog(fp,Mp,vp,[],[],Bound_L,Bound_U);
    time_lp(Img_index)=toc;
    disp('LP:=')
    disp(dp);
    opt_lp(Img_index)=dp;
    opt_lp(Img_index)=opt_lp(Img_index);
    
    

end


function [A,b]=GengerateRowSparseMatrix(n1,n2,s)

A=sign(randn(n1,n2));

At=zeros(n1,n2);
if s<inf
for k=1:n1
    At(k,randperm(n2,s))=1;
end
A=At.*A;
end



Av=abs(A);
Av=sum(Av,2);
 b=(Av*0.9).*rand(n1,1).*sign(randn(n1,1));
end
