%% Compute bounds from SDP_L2 with Bound
clear
clc

% NetDataPath=[pwd '\data\net_data__19.07.txt'];
NetDataPath=[pwd '\data\net_data_2x500.txt'];
fileID = fopen( NetDataPath, 'r');
json_text = fread(fileID, '*char').';
fclose(fileID);
% decoding JSON
data = jsondecode(json_text);
A=data.A;

b=data.b;

eps_tol=10/255;
% When eps_tol is too small, all of the nodes may be deterministic, implying that the network is robust. 

fileID = fopen('img_test_data.txt', 'r');
json_text = fread(fileID, '*char').';
fclose(fileID);
Img_data = jsondecode(json_text);
X=Img_data.img;
Train_Label=Img_data.img_lb;


 

for i=1:length(A)
    A_nv=A{i};
    A_nv=vecnorm(A_nv,inf,2);
    A_nv=1./A_nv;
    A{i}=diag(A_nv)*A{i};
    b{i}=diag(A_nv)*b{i};
end



for Img_index=1:100

    x=X(Img_index,:);
    x0=x(:);
    % cd ..

    bias=b;

    W=A;
    W(end)=[];
    bias(end)=[];
    [~,o]=RunBNN(W,bias,x0);
    y=A{end}*o{end}+b{end};


    [~,y_order]=sort(y,'descend');
    T_label=y_order(1);
    Att_label=y_order(2);
    % Att_label=1;
    f=A{end}(T_label,:)-A{end}(Att_label,:);
    Robust_bound=b{end}(T_label)-b{end}(Att_label,:);
    f=double(f);

    Lb=-1+0*x0;
    Ub= 1+0*x0; 
    [As,bs,fs,cs,Index_pos,Index_neg,bound_L,bound_U]=Prob2std_prob_l2_with_bound(W,bias,x0, eps_tol,f,Lb,Ub);

    for i=1:length(As)
        Ap{i}=double(As{i});

    end

    for i=1:length(bs)
        bp{i}=double(bs{i});
    end

    obj_F=fs;
    obj_F=double(obj_F);


    imshow(reshape(x0,[28,28]))
    disp('T_label=')
    disp(T_label)

    if ((1+Train_Label(Img_index))~=T_label)
        disp('Wrong Classification')
        continue
    end
    pause(1e-5);


    % Ap


    % disp([cs+Robust_bound])   % cs: deterministic nodes from the Last hidden layer that are added to the bias from the obj_f

    ooptions=BNNVoptions();
    options.norm=2;
    options.type='tighter';
    options.solver= 'Mosek';
    options.sparsity = 'CSTSSOS';
    options.clique = 'CM';
    options.order=1 ;

    options.Lb=bound_L;

    options.Ub=bound_U;
    % disp('BNNV2POP tighter:')
    options.type='tighter';

    try
        BNNV2POP_Large(Ap,bp,{obj_F},options);
        diary('BNNV_output.log')
        system(['julia JuliaCode.jl'] ,'-echo');
        diary off
        [opt_sdp(Img_index),time_sdp(Img_index)]=Read_Output_of_TSSOS('BNNV_output.log');
        movefile('BNNV_output.log',['BNNV_output-l2-Index-'  num2str(Img_index) 'eps-' num2str(eps_tol) '.log'],'f')
    catch
        opt_sdp(Img_index)=nan;
        time_sdp(Img_index)=nan;
    end




    opt_sdp(Img_index)=cs+Robust_bound+opt_sdp(Img_index);

end


