function [fval,xp,fp,intcon,Mp,vp,time,output]=Grb_sof_Fesiable_L2(A,b,obj_f,soft_tol,robust_bound,Lb,Ub)
% input: Std L2 verificiation prob A ,b obj_F
% solve
% min 0
%s.t. <obj_f,x{end}> >=robust_bound
%      x{i} \in BNN
%      ||x{0}||<=1
%      Lb<=x{0}<=Ub

if nargin==3
soft_tol=0;
end
n(1)=size(A{1},2);
for i=1:length(A)
    n(i+1)=size(A{i},1);
end

x=sym('x',[n(1),1]);
y=sym('y',[sum(n(2:end)),1]);
var=[x;y];
V{1}=x;
k=1;
for i=1:length(A)
    Y{i}=y(k:(k+n(i+1)-1));
    Y{i}=2*Y{i}-1;
    k=k+n(i+1);
end

S={V{:},Y{:}};
  
[Mp,vp]=BNN2GrbLinearConds_with_bound(A,b,soft_tol,Lb,Ub);
f=dot(obj_f,S{end});
[fp,cs]=equationsToMatrix(f==0,var);
fp=double(fp);
intcon=1:length(fp);

intcon(1:n(1))=[];



disp('grb const:')

disp(double(cs));

A=-Mp;
b=-vp;
A=[A;fp(:)'];
b=[b;double(cs)-robust_bound]; 
options.MaxTime=600; 
 
Bound_L_mod=Lb;
Bound_L_mod(intcon)=-0.1;
Bound_U_mod=Ub;
Bound_U_mod(intcon)=1.1; 
 tic; 
 [fval,x,exitflag,output]=Groubi_MIQP(0*fp,intcon,A,b,[],[],Bound_L_mod,Bound_U_mod,[],options);
time=toc;


if isempty(x)
    fval=inf;
    xp=[];

    return
end
xp=x;
xp(intcon)=2*xp(intcon)-1;
fval=fval-double(cs);

end
 