function [fval,x]=Sampling_For_UB(A,b,x0,f,eps,typeofnorm)
%----------------------------------
% compute fesiable solution and upper bound for opt value of BNN verification prob,
% input: A,b define the BNN net\work
% x0: input data
% eps: esp norm bound;
% typeofnorm:type of norm ,can be inf or 2
%

% consider:
% min <f,y>
% s.t. y=BNN(x)
%      \|x-x0\|_typeofnorm<=eps
%      -1<=x<=1
% output:
% fval: min value of sandom sampling points
% x: minvalue of x;
%----------------------------------
RepeatTimes=10000;


if typeofnorm==inf
    L=x0-eps;L=max(L,0*L-1);
    U=eps+x0;U=min(U,0*U+1);
    x=x0;
    [y,o]=RunBNN(A,b,x);
    fval=dot(o{end},f);

    for i=1:RepeatTimes
        t=rand(length(x0),1);
        xt=L+(U-L).*t;
        [yt,ot]= RunBNN(A,b,xt);
        fvalt=dot(ot{end},f);
        if fvalt<fval
            fval=fvalt;
            x=xt;
        end

    end

end




end