def general_assertions(args):
    # Ensure appropriate settings for subgraph sampling and result averaging
    if args.data.sampling.keep_subgraph_prob == 1 and args.data.sampling.average_res_over > 1:
        raise ValueError("If keep_subgraph_prob is 1 (keeping all subgraphs), average_res_over should be 1 to avoid incorrect averaging over multiple results.")

    # Ensure that the architecture is product_graph_Mpnn or Mpnn
    if args.model.model_name not in ['product_graph_Mpnn', 'product_graph_Mpnn_sum', 'Mpnn', 'Mpnn_sum']:
        raise ValueError(
            "The model architecture must be either 'product_graph_Mpnn' or 'Mpnn'.")
