# Colabs

This directory contains
[`utils.py`](https://github.com/google/dopamine/blob/master/dopamine/colab/utils.py),
which provides a number of useful utilities for loading experiment statistics.

We also provide a set of colabs to help illustrate how you can use Dopamine.

## Agents

In this
[colab](https://colab.research.google.com/github/google/dopamine/blob/master/dopamine/colab/agents.ipynb)
we illustrate how to create a new agent by either subclassing
[`DQN`](https://github.com/google/dopamine/blob/master/dopamine/agents/dqn/dqn_agent.py)
or by creating a new agent from scratch.

## Loading statistics

In this
[colab](https://colab.research.google.com/github/google/dopamine/blob/master/dopamine/colab/load_statistics.ipynb)
we illustrate how to load and visualize the logs data produced by Dopamine.

## Visualizing trained agents
In this
[colab](https://colab.research.google.com/github/google/dopamine/blob/master/dopamine/colab/agent_visualizer.ipynb)
we illustrate how to visualize a trained agent using the visualization utilities
provided with Dopamine.

In [this colab](https://colab.research.google.com/github/google/dopamine/blob/master/dopamine/colab/jax_agent_visualizer.ipynb)
we can visualize trained agents' performance with the agents trained with the
[JAX implementations](https://github.com/google/dopamine/tree/master/dopamine/jax).

## Visualizing with Tensorboard
In this
[colab](https://colab.research.google.com/github/google/dopamine/blob/master/dopamine/colab/tensorboard.ipynb)
we illustrate how to download and visualize different agents with Tensorboard.

## Training on Cartpole
In this
[colab](https://colab.research.google.com/github/google/dopamine/blob/master/dopamine/colab/cartpole.ipynb)
we illustrate how to train DQN and C51 on the Cartpole environment.
