# README

## Quick Start

- config: 
  - query_index: Specify the index of the question, starting from 0. Multiple indexes are allowed, separated by `,`. The default is all queries. `m-n` can be used to specify a range of indexes. 
  - query_path: Specify the relative file path to `test.py` for the question, which should be a json file.
  - baseline:
    - name: Specify the name of the baseline, currently supports [ActPlanner, ReactPlanner].
    - llm: Specify the llm model class name used for the baseline, any baseline requires llm model.
    - planner: A json version of the planner model to generate legal plans.
  - num_processes: Specify the number of processes for multi-process testing. This parameter is ignored when using `test.py`.
  - shot_num: Specify the number of shots for baseline `ReactPlanner`. 0 or 1.

- run:
  - `python test.py` to start testing. Supports the parameter `--config` to specify the configuration file path, default is `config.yaml`.
  - `python multi_process_test.py` to start testing in multi-process mode. Supports the parameter `--config` to specify the configuration file path, default is `config.yaml`.

- log:
  - The generated log files are saved in the `logs/test_{timestamp}/` directory.
    - test.log: The log of the entire test.
    - query_{query_index}_log.json: The log of each question.

- result:
  - The generated results are saved in the `results/test_{timestamp}/` directory.
    - query_{query_index}_result.json: The result of the successfully planned question.
    - query_{query_index}_result.json: The result of the successfully planned question.

## FILE STRUCTURE

- `data/`: Test environment query files
- `database/`: Test environment data files
- `evaluation/`: Evaluation code
- `logs/`: Log files
- `results/`: Result files
- `tools/`: Environment API
- `baselines.py`: Baseline code
- `envs.py`: Interaction environment used by the model
- `llms.py`: llm model API
- `test_prompts.py`: Code for storing prompts
- `test.py`: Test code
- `tmp_prompt.txt`: File to display prompts when using `human` as llm
- `NS_agent`: Neural-Symbolic method
