# README

## Quick Start

- config: 
  - query_index: 用于指定问题的下标，从 0 开始。允许多个下标，用 `,` 分隔。默认为所有query，支持`m-n`表示的范围。
  - query_path: 用于指定问题的相对`test.py`的文件路径，应当为json文件。
  - baseline:
    - name: 用于指定baseline的名称，目前支持[ActPlanner, ReactPlanner、]
    - llm: 指定用于baseline的llm模型类名，任何一个baseline都需要一个llm模型。
    - planner: llm的json版本，用于生成合法的规划。
  - num_processes: 用于指定多进程测试时的进程数。使用`test.py`时会忽略此参数。
  - shot_num: 用于指定`ReactPlanner`的shot数。0或1。
- run:
  -  `python test.py` 以开始测试。支持参数 `--config` 指定配置文件路径，默认为 `config.yaml`。
  -  `python multi_process_test.py` 以多进程方式开始测试。支持参数 `--config` 指定配置文件路径，默认为 `config.yaml`。
- log:
  - 生成的日志文件保存在 `logs/test_{timestamp}/` 目录下。
    - test.log: 整个测试的日志。
    - query_{query_index}_log.json: 每个问题的日志。
- result:
  - 生成的结果保存在 `results/test_{timestamp}/` 目录下。
    - query_{query_index}_result.json: 成功规划的问题的结果。

## FILE STRUCTURE

- `data/`: 测试环境query文件
- `database/`: 测试环境数据文件
- `evaluation/`: 评估代码
- `logs/`: 日志文件
- `results/`: 结果文件
- `tools/`: 环境API
- `baselines.py`: baseline代码
- `envs.py`: 模型使用的交互环境
- `llms.py`: llm模型API
- `test_prompts.py`: 存放prompt的代码
- `test.py`: 测试代码
- `tmp_prompt.txt`: 使用`human`作为llm时，展示prompt的文件
- `NS_agent`: Neural-Symbolic 方法 