import json
import pandas as pd


def get_rank_with_value(value_list, better_type: str):
    pandas_data = pd.Series(value_list)
    if better_type == "max":
        rank = pandas_data.rank(ascending=False, method="min")
    elif better_type == "min":
        rank = pandas_data.rank(ascending=True, method="min")
    return rank.tolist()


def load_query_from_json(file_path):
    query = []
    with open(file_path, "r", encoding="utf-8") as f:
        data_list = json.load(f)
    for data in data_list:
        query.append(data)
    return query


results_base_path = ["../results/NS_results/deepseek_json/",
                     "../results/NS_results/model_glm4_json/",
                     "../results/NS_results/model_GPT_json/"]
method_name = ["deepseek+ns", "model_glm4+ns", "model_GPT+ns"]
query_data = "preference_data.json"
query_data_withoutjson = "preference_data/"
results_path = [base_dir +
                query_data_withoutjson for base_dir in results_base_path]
query_data_path = "../data/" + query_data

query_data = load_query_from_json(query_data_path)
data_len = len(query_data)
preference_list = ["convenient transportation", "convenient restaurant",
                   "close to poi", "less walk",
                   "more cost on meals", "more cost on hotel", "more cost on attractions",
                   "less cost on meals", "less cost on hotel", "less cost on attractions",
                   "less total cost",
                   "easy trip", "more attractions",
                   "more indoor attractions", "more outdoor attractions",
                   "more popular attractions", "more unpopular attractions",
                   ]
func_result_name_list = ['convenient_transport', 'convenient_restaurant', 'near_poi', 'less_walk', 'meal_cost_ratio', 'accommodation_cost_ratio',
                         'attraction_cost_ratio', 'total_cost', 'attraction_satisfaction', 'attraction_count', 'indoor_attraction_ratio', 'popular_attraction_ratio']

rank_result = {}
result_data = {}
for preference in preference_list:
    rank_result[preference] = {}
    for m_name in method_name:
        rank_result[preference][m_name] = []
        rank_result[preference][m_name + "_avg"] = 0


for m_name in method_name:
    result_data[m_name] = []
for idx, path in enumerate(results_path):
    for i in range(data_len):
        with open(path + "preference_" + str(i) + ".json") as f:
            result_data[method_name[idx]].append(json.load(f))


def get_rank_result():
    for idx, query in enumerate(query_data):
        tmp_result_list = []
        for m_name in method_name:
            tmp_result_list.append(result_data[m_name][idx])
        if "convenient transportation" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["convenient_transport"] for v in tmp_result_list]
            max_value = max(value_list)
            for v in value_list:
                if v == -1:
                    v = max_value + 1
            for i, res in enumerate(tmp_result_list):
                if res["status"] == False:
                    value_list[i] = max_value + 1
            # sorted_index = sorted(range(len(value_list)),
            #                       key=lambda k: value_list[k])
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            tmp_rank = get_rank_with_value(value_list, "min")
            for i in range(len(method_name)):
                rank_result["convenient transportation"][method_name[i]].append(
                    tmp_rank[i])
        if "convenient restaurants" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["convenient_restaurant"] for v in tmp_result_list]
            max_value = max(value_list)
            for v in value_list:
                if v == -1:
                    v = max_value + 1
            for i, res in enumerate(tmp_result_list):
                if res["status"] == False:
                    value_list[i] = max_value + 1
            # sorted_index = sorted(range(len(value_list)),
            #                       key=lambda k: value_list[k])
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            tmp_rank = get_rank_with_value(value_list, "min")
            for i in range(len(method_name)):
                rank_result["convenient restaurant"][method_name[i]].append(
                    tmp_rank[i])

        if "close to" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["near_poi"] for v in tmp_result_list]
            max_value = max(value_list)
            for v in value_list:
                if v == -1:
                    v = max_value + 1
            for i, res in enumerate(tmp_result_list):
                if res["status"] == False:
                    value_list[i] = max_value + 1
            # sorted_index = sorted(range(len(value_list)),
            #                       key=lambda k: value_list[k])
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            tmp_rank = get_rank_with_value(value_list, "min")
            for i in range(len(method_name)):
                rank_result["close to poi"][method_name[i]].append(tmp_rank[i])

        if "less walk" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["less_walk"] for v in tmp_result_list]
            max_value = max(value_list)
            for v in value_list:
                if v == -1:
                    v = max_value + 1
            for i, res in enumerate(tmp_result_list):
                if res["status"] == False:
                    value_list[i] = max_value + 1
            # sorted_index = sorted(range(len(value_list)),
            #                       key=lambda k: value_list[k])
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            tmp_rank = get_rank_with_value(value_list, "min")
            for i in range(len(method_name)):
                rank_result["less walk"][method_name[i]].append(tmp_rank[i])

        if "more cost on meals" or "less cost on meals" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["meal_cost_ratio"] for v in tmp_result_list]
            # print(tmp_result_list)
            min_value = min(value_list)
            max_value = max(value_list)
            if "more cost on meals" in query["preference_en"]:
                for v in value_list:
                    if v == -1:
                        v = min_value - 1
                for i, res in enumerate(tmp_result_list):
                    if res["status"] == False:
                        value_list[i] = min_value - 1

                # sorted_index = sorted(
                #     range(len(value_list)), key=lambda k: value_list[k], reverse=True)
                tmp_rank = get_rank_with_value(value_list, "max")
            elif "less cost on meals" in query["preference_en"]:
                for v in value_list:
                    if v == -1:
                        v = max_value + 1
                for i, res in enumerate(tmp_result_list):
                    if res["status"] == False:
                        value_list[i] = max_value + 1

                # sorted_index = sorted(
                #     range(len(value_list)), key=lambda k: value_list[k])
                tmp_rank = get_rank_with_value(value_list, "min")
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            for i in range(len(method_name)):
                if "more cost on meals" in query["preference_en"]:
                    rank_result["more cost on meals"][method_name[i]].append(
                        tmp_rank[i])
                elif "less cost on meals" in query["preference_en"]:
                    rank_result["less cost on meals"][method_name[i]].append(
                        tmp_rank[i])

        if "more cost on hotel" or "less cost on hotel" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["accommodation_cost_ratio"]
                          for v in tmp_result_list]
            min_value = min(value_list)
            max_value = max(value_list)
            if "more cost on hotel" in query["preference_en"]:
                for v in value_list:
                    if v == -1:
                        v = min_value - 1
                for i, res in enumerate(tmp_result_list):
                    if res["status"] == False:
                        value_list[i] = min_value - 1

                # sorted_index = sorted(
                #     range(len(value_list)), key=lambda k: value_list[k], reverse=True)
                tmp_rank = get_rank_with_value(value_list, "max")
            elif "less cost on hotel" in query["preference_en"]:
                for v in value_list:
                    if v == -1:
                        v = max_value + 1
                for i, res in enumerate(tmp_result_list):
                    if res["status"] == False:
                        value_list[i] = max_value + 1

                # sorted_index = sorted(
                #     range(len(value_list)), key=lambda k: value_list[k])
                tmp_rank = get_rank_with_value(value_list, "min")
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            for i in range(len(method_name)):
                if "more cost on hotel" in query["preference_en"]:
                    rank_result["more cost on hotel"][method_name[i]].append(
                        tmp_rank[i])
                elif "less cost on hotel" in query["preference_en"]:
                    rank_result["less cost on hotel"][method_name[i]].append(
                        tmp_rank[i])

        if "more cost on attractions" or "less cost on attractions" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["attraction_cost_ratio"] for v in tmp_result_list]
            min_value = min(value_list)
            max_value = max(value_list)
            if "more cost on attractions" in query["preference_en"]:
                for v in value_list:
                    if v == -1:
                        v = min_value - 1
                for i, res in enumerate(tmp_result_list):
                    if res["status"] == False:
                        value_list[i] = min_value - 1

                # sorted_index = sorted(
                #     range(len(value_list)), key=lambda k: value_list[k], reverse=True)
                tmp_rank = get_rank_with_value(value_list, "max")
            elif "less cost on attractions" in query["preference_en"]:
                for v in value_list:
                    if v == -1:
                        v = max_value + 1
                for i, res in enumerate(tmp_result_list):
                    if res["status"] == False:
                        value_list[i] = max_value + 1

                # sorted_index = sorted(
                #     range(len(value_list)), key=lambda k: value_list[k])
                tmp_rank = get_rank_with_value(value_list, "min")
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            for i in range(len(method_name)):
                if "more cost on attractions" in query["preference_en"]:
                    rank_result["more cost on attractions"][method_name[i]].append(
                        tmp_rank[i])
                elif "less cost on attractions" in query["preference_en"]:
                    rank_result["less cost on attractions"][method_name[i]].append(
                        tmp_rank[i])

        if "less total cost" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["total_cost"] for v in tmp_result_list]
            max_value = max(value_list)
            for v in value_list:
                if v == -1:
                    v = max_value + 1
            for i, res in enumerate(tmp_result_list):
                if res["status"] == False:
                    value_list[i] = max_value + 1
            # sorted_index = sorted(range(len(value_list)),
            #                       key=lambda k: value_list[k])
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            tmp_rank = get_rank_with_value(value_list, "min")
            for i in range(len(method_name)):
                rank_result["less total cost"][method_name[i]].append(
                    tmp_rank[i])

        if "easy trip" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["attraction_satisfaction"]
                          for v in tmp_result_list]
            min_value = min(value_list)
            for v in value_list:
                if v == -1:
                    v = min_value - 1
            for i, res in enumerate(tmp_result_list):
                if res["status"] == False:
                    value_list[i] = min_value - 1

            # sorted_index = sorted(range(len(value_list)),
            #                       key=lambda k: value_list[k], reverse=True)
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            tmp_rank = get_rank_with_value(value_list, "max")
            for i in range(len(method_name)):
                rank_result["easy trip"][method_name[i]].append(tmp_rank[i])

        if "more attractions" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["attraction_count"] for v in tmp_result_list]
            min_value = min(value_list)
            for v in value_list:
                if v == -1:
                    v = min_value - 1
            for i, res in enumerate(tmp_result_list):
                if res["status"] == False:
                    value_list[i] = min_value - 1

            # sorted_index = sorted(range(len(value_list)),
            #                       key=lambda k: value_list[k], reverse=True)
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            tmp_rank = get_rank_with_value(value_list, "max")
            for i in range(len(method_name)):
                rank_result["more attractions"][method_name[i]].append(
                    tmp_rank[i])

        if "more indoor attractions" or "more outdoor attractions" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["indoor_attraction_ratio"]
                          for v in tmp_result_list]
            min_value = min(value_list)
            max_value = max(value_list)
            if "more indoor attractions" in query["preference_en"]:
                for v in value_list:
                    if v == -1:
                        v = min_value - 1
                for i, res in enumerate(tmp_result_list):
                    if res["status"] == False:
                        value_list[i] = min_value - 1

                # sorted_index = sorted(
                #     range(len(value_list)), key=lambda k: value_list[k], reverse=True)
                tmp_rank = get_rank_with_value(value_list, "max")
            elif "more outdoor attractions" in query["preference_en"]:
                for v in value_list:
                    if v == -1:
                        v = max_value + 1
                for i, res in enumerate(tmp_result_list):
                    if res["status"] == False:
                        value_list[i] = max_value + 1

                # sorted_index = sorted(
                #     range(len(value_list)), key=lambda k: value_list[k])
                tmp_rank = get_rank_with_value(value_list, "min")
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            for i in range(len(method_name)):
                if "more indoor attractions" in query["preference_en"]:
                    rank_result["more indoor attractions"][method_name[i]].append(
                        tmp_rank[i])
                elif "more outdoor attractions" in query["preference_en"]:
                    rank_result["more outdoor attractions"][method_name[i]].append(
                        tmp_rank[i])

        if "more popular attractions" or "more unpopular attractions" in query["preference_en"]:
            # tmp_result_list = []
            sorted_index = []
            tmp_rank = [0 for i in range(len(method_name))]
            value_list = [v["popular_attraction_ratio"]
                          for v in tmp_result_list]
            min_value = min(value_list)
            max_value = max(value_list)
            if "more popular attractions" in query["preference_en"]:
                for v in value_list:
                    if v == -1:
                        v = min_value - 1
                for i, res in enumerate(tmp_result_list):
                    if res["status"] == False:
                        value_list[i] = min_value - 1

                # sorted_index = sorted(
                #     range(len(value_list)), key=lambda k: value_list[k], reverse=True)
                tmp_rank = get_rank_with_value(value_list, "max")
            elif "more unpopular attractions" in query["preference_en"]:
                for v in value_list:
                    if v == -1:
                        v = max_value + 1
                for i, res in enumerate(tmp_result_list):
                    if res["status"] == False:
                        value_list[i] = max_value + 1

                # sorted_index = sorted(
                #     range(len(value_list)), key=lambda k: value_list[k])
                tmp_rank = get_rank_with_value(value_list, "min")
            # for i, index in enumerate(sorted_index):
            #     tmp_rank[index] = i + 1
            for i in range(len(method_name)):
                if "more popular attractions" in query["preference_en"]:
                    rank_result["more popular attractions"][method_name[i]].append(
                        tmp_rank[i])
                elif "more unpopular attractions" in query["preference_en"]:
                    rank_result["more unpopular attractions"][method_name[i]].append(
                        tmp_rank[i])


get_rank_result()
for preference in preference_list:
    for m_name in method_name:
        if len(rank_result[preference][m_name]) != 0:
            rank_result[preference][m_name + "_avg"] = sum(
                rank_result[preference][m_name]) / len(rank_result[preference][m_name])

for path, m_name in zip(results_base_path, method_name):
    # for m_name in method_name:
    with open(path + m_name + "_rank.json", "w") as f:
        json.dump(rank_result, f)

print(rank_result)
