import json


def load_query_from_json(file_path="evaluation/example/examples_new.json"):
    query = []
    with open(file_path, "r", encoding="utf-8") as f:
        data_list = json.load(f)
    for data in data_list:
        query.append(data)
    return query


def get_info_for_Direct_CoT(query_json, env):
    start_city = query_json["start_city"]
    end_city = query_json["target_city"]
    hotel_info = env.run(
        "accommodations_select('{}','name',lambda x:True)".format(end_city))
    restaurant_info = env.run(
        "restaurants_select('{}','name',lambda x:True)".format(end_city))
    attraction_info = env.run(
        "attractions_select('{}','name',lambda x:True)".format(end_city))
    intercity_transport_info_air = env.run(
        "intercity_transport_select('{}','{}','airplane')".format(start_city, end_city))
    intercity_transport_info_train = env.run(
        "intercity_transport_select('{}','{}','train')".format(start_city, end_city))
    intercity_transport_info_air_back = env.run(
        "intercity_transport_select('{}','{}','airplane')".format(end_city, start_city))
    intercity_transport_info_train_back = env.run(
        "intercity_transport_select('{}','{}','train')".format(end_city, start_city))
    res_str = hotel_info.str__10data() + restaurant_info.str__10data() + \
        attraction_info.str__10data() + intercity_transport_info_air.str__10data() + \
        intercity_transport_info_train.str__10data() + \
        intercity_transport_info_air_back.str__10data() + \
        intercity_transport_info_train_back.str__10data()
    inner_city_transport_info = ""
    poi_name = []
    tmp_num = 0
    for poi in attraction_info.data["name"].values:
        tmp_num += 1
        poi_name.append(poi)
        if tmp_num >= 10:
            break
    tmp_num = 0
    for poi in hotel_info.data["name"].values:
        tmp_num += 1
        poi_name.append(poi)
        if tmp_num >= 10:
            break
    tmp_num = 0
    for poi in restaurant_info.data["name"].values:
        tmp_num += 1
        poi_name.append(poi)
        if tmp_num >= 10:
            break

    for i in range(len(poi_name)):
        # print(i)
        for j in range(i+1, len(poi_name)):
            # print(j)
            inner_city_transport_info += env.run(
                "goto('{}','{}','{}','00:00','walk')".format(end_city, poi_name[i], poi_name[j])).str__10data() + "\n"
            inner_city_transport_info += env.run(
                "goto('{}','{}','{}','00:00','taxi')".format(end_city, poi_name[i], poi_name[j])).str__10data() + "\n"
            inner_city_transport_info += env.run(
                "goto('{}','{}','{}','00:00','metro')".format(end_city, poi_name[i], poi_name[j])).str__10data() + "\n"
    inner_city_transport_info += """Note that all transportation methods are available in 24 hours, so we use '00:00' as the time. You can change the time into the actual time you want to go. For example, if you want to go to the restaurant at 8:00, you can change '00:00' to '08:00' in the command. All the transportation methods are also bidirectional with the same cost of time and money. """
    res_str += inner_city_transport_info

    return res_str


def get_query_index_list(query_index):
    if query_index == None:
        return None
    else:
        if isinstance(query_index, int):
            query_index = [query_index]
        else:
            query_index = query_index.split(",")

            def tmp(x):
                if "-" in x:
                    a, b = x.split("-")
                    return list(range(int(a), int(b)+1))
                else:
                    return [int(x)]
            query_index = [i for x in query_index for i in tmp(x)]
    return query_index
