# train.py
#!/usr/bin/env	python3

""" train network using pytorch

author baiyu
"""

import os
import sys
import argparse
import time
from datetime import datetime

import numpy as np
import torch
import torch.nn as nn
import torch.optim as optim
import torchvision
import torchvision.transforms as transforms

from torch.utils.data import DataLoader
from torch.utils.tensorboard import SummaryWriter

from conf import settings
from utils import get_network, get_training_dataloader, get_test_dataloader, WarmUpLR, \
    most_recent_folder, most_recent_weights, last_epoch, best_acc_weights

from adam_microbatch_grad import Adam
from MicroGradScheduler import MicroGradScheduler

def train(epoch, grad_accumulate_step, batch_size):

    start = time.time()
    net.train()
    for batch_index, (images, labels) in enumerate(cifar100_training_loader):

        if args.gpu:
            labels = labels.cuda()
            images = images.cuda()

        # ========================micro-batch=======================
        labels_microbatches = torch.split(labels, int(batch_size/grad_accumulate_step))
        images_microbatches = torch.split(images, int(batch_size/grad_accumulate_step))

        
        loss_total = 0
        for micro_num in range(len(labels_microbatches)):
            outputs_microbatch = net(images_microbatches[micro_num])
            loss = loss_function(outputs_microbatch, labels_microbatches[micro_num]) / len(labels_microbatches)
            loss.backward()
            loss_total += loss.item()
            grad_scheduler.windup_optim_step()
    finish = time.time()

    print('epoch {} training time consumed: {:.2f}s'.format(epoch, finish - start))


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('-net', type=str, required=True, help='net type')
    parser.add_argument('-gpu', action='store_true', default=False, help='use gpu or not')
    parser.add_argument('-b', type=int, default=128, help='batch size for dataloader')
    parser.add_argument('-warm', type=int, default=1, help='warm up training phase')
    parser.add_argument('-lr', type=float, default=3e-4, help='initial learning rate')
    parser.add_argument('-resume', action='store_true', default=False, help='resume training')
    parser.add_argument('--grad_accumulate_step', type=int, default=2, help='grad_accumulate_step')
    args = parser.parse_args()

    device = "cuda:0"
    net = get_network(args, device)

    #data preprocessing:
    cifar100_training_loader = get_training_dataloader(
        settings.CIFAR100_TRAIN_MEAN,
        settings.CIFAR100_TRAIN_STD,
        num_workers=4,
        batch_size=args.b,
        shuffle=True
    )

    loss_function = nn.CrossEntropyLoss()
    optimizer  = Adam(net.parameters(), args.grad_accumulate_step, lr=args.lr)
    train_scheduler = optim.lr_scheduler.MultiStepLR(optimizer, milestones=settings.MILESTONES, gamma=0.2) #learning rate decay
    iter_per_epoch = len(cifar100_training_loader)

    grad_scheduler = MicroGradScheduler(net, optimizer)



    best_acc = 0.0

    for epoch in range(1, settings.EPOCH + 1):
        train(epoch, args.grad_accumulate_step, args.b)


