# CP on Time-Dependent PDEs

A project exploring the use of Conformal Prediction techniques for time-dependent partial differential equations.

## Installation

### Option 1: Using uv (recommended)

```bash
uv venv .venv
source .venv/bin/activate # On macOS/Linux
uv pip install -e .
```

### Option 2: Using pip

```bash
python -m venv .venv
source .venv/bin/activate # On macOS/Linux
pip install -e .
```

### Install LSCI (no pip package available)

```bash
git clone https://github.com/trevor-harris/LSCI.git
uv pip install -e ./LSCI
```
> **Remark for Reviewers.** Shortly before submission, we noticed that the LSCI repository was taken down. This is probably due to a conference submission and we expect the repository to re-appear at a later time.

## Usage

### Data Generation

Generate datasets with the scripts in the data_generation/ directory.

```bash
./data_generation/generate_data.sh
```

### Model Training

Train models using the scripts in the experiments/ directory.

```bash
./experiments/train_base_models.sh
```

### Conformal Prediction Results

All results are obtained using

```bash
./experiments/fd_covariate_shift.ipynb
```

## Requirements

- Python >= 3.13
- See pyproject.toml for the full list of dependencies.
