#!/bin/bash
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

# Create output directory if it doesn't exist
mkdir -p "$SCRIPT_DIR/../data/antidiff"

# Generate Fractional Diffusion Data
python "$SCRIPT_DIR/antidiff.py" -n 1000 --T 0.2 --dt 0.002 \
  -o "$SCRIPT_DIR/../data/antidiff/antidiff_train.npz" --alpha 0.5 --sigma 0.08 --nx 256 --seed 42

python "$SCRIPT_DIR/antidiff.py" -n 100 --T 0.2 --dt 0.002 \
  -o "$SCRIPT_DIR/../data/antidiff/antidiff_val.npz" --alpha 0.5 --sigma 0.08 --nx 256 --seed 43

python "$SCRIPT_DIR/antidiff.py" -n 500 --T 0.2 --dt 0.002 \
  -o "$SCRIPT_DIR/../data/antidiff/antidiff_calib.npz" --alpha 0.5 --sigma 0.08 --nx 256 --seed 44

python "$SCRIPT_DIR/antidiff.py" -n 500 --T 0.2 --dt 0.002 \
  -o "$SCRIPT_DIR/../data/antidiff/antidiff_test.npz" --alpha 0.5 --sigma 0.08 --nx 256 --seed 45


# Generate Backwards Heat Data
mkdir -p "$SCRIPT_DIR/../data/bwheat"

python "$SCRIPT_DIR/backwards_heat.py" -n 1000 --T 0.005 --dt 0.00005 -o "$SCRIPT_DIR/../data/bwheat/bwheat_train.npz" --nx 256 --seed 42

python "$SCRIPT_DIR/backwards_heat.py" -n 100 --T 0.005 --dt 0.00005 -o "$SCRIPT_DIR/../data/bwheat/bwheat_val.npz" --nx 256 --seed 43

python "$SCRIPT_DIR/backwards_heat.py" -n 500 --T 0.005 --dt 0.00005 -o "$SCRIPT_DIR/../data/bwheat/bwheat_calib.npz" --nx 256 --seed 44

python "$SCRIPT_DIR/backwards_heat.py" -n 500 --T 0.005 --dt 0.00005 -o "$SCRIPT_DIR/../data/bwheat/bwheat_test.npz" --nx 256 --seed 45


# Generate Reaction-Diffusion Data
mkdir -p "$SCRIPT_DIR/../data/reaction"

python "$SCRIPT_DIR/reaction.py" -n 1000 --T 0.2 --dt 0.002 -o "$SCRIPT_DIR/../data/reaction/reaction_train.npz" --nx 256 --seed 42

python "$SCRIPT_DIR/reaction.py" -n 100 --T 0.2 --dt 0.002 -o "$SCRIPT_DIR/../data/reaction/reaction_val.npz" --nx 256 --seed 43

python "$SCRIPT_DIR/reaction.py" -n 500 --T 0.2 --dt 0.002 -o "$SCRIPT_DIR/../data/reaction/reaction_calib.npz" --nx 256 --seed 44

python "$SCRIPT_DIR/reaction.py" -n 500 --T 0.2 --dt 0.002 -o "$SCRIPT_DIR/../data/reaction/reaction_test.npz" --nx 256 --seed 45

