###  Example Code for SAFA-SNN: Sparsity-Aware On-device Few-Shot Class-Incremental Learning with Fast-Adaptive Structure of Spiking Neural Network

Example code is provided in the supplementary materials. To demonstrate the core idea of **SAFA-SNN**, we include a simplified, standalone PyTorch implementation simulating a layer-wise backdoor attack on a Spiking VGG9 model trained on the CIFAR-100 dataset. The example consists of three main stages:

1. **Base Training**  
   The model is first trained for several epochs on clean CIFAR-100 in the base session data. This setup includes sparsity-aware neuron dynamics with masks and zeroth-order optimization.

2. **Incremental learning**  
   The model are only conducted inference in the incremental learning. Only the classifiers for novel classes are updated with prototypes. This design reflects SAFA-SNN's core principle: to avoid overfitting on novel data.

3. **Evaluation**  
   We report accuracy on all seen classes after each session.

> ⚠️ **Note:** This example omits full few-shot class-incremental learning and data splitting for simplicity. It is designed to highlight the essential workflow of SAFA-SNN in a concise and illustrative manner.
