#pragma once

#include <thread>
#include <queue>
#include <mutex>
#include <condition_variable>
#include <functional>

namespace GPT {

class TaskExecutor {
  public:
    TaskExecutor(int num_workers);
    virtual ~TaskExecutor();

    
    template<class F, class... Args>
    void enqueue(F&& f, Args&&... args) {
        {
            std::unique_lock<std::mutex> lock(queue_mutex_);
            tasks_.emplace([=] { f(args...); });
        }
        condition_.notify_one();
    }

  private:
    std::vector<std::thread> workers_;

    std::queue<std::function<void()>> tasks_; 
    std::mutex queue_mutex_;
    std::condition_variable condition_;

    bool stop_;
};
}