# Towards Pre-trained Graph Condensation via Optimal Transport

## Environment Settings

> python=3.11.5
> torch_geometric==2.5.0
> torch==2.2.0
> scikit-learn==1.3.0
> POT==0.9.5 

## Usage

You can use the following command to test condensed graph obtained by PreGC:

> python train_ohter_task.py

Here, we set the dataset as "Pubmed" by default, with "0.15%" condensation ratio, "SGC" architecture, and "node classification" task.

## Other Scenarios

You can change the GNN architecture, tasks, and condensation ratio to obtain different results.
For example:

> python train_ohter_task.py --model appnp --reduction_rate 0.25 --task lp

## Fine-tuning

In addition, you can get better performance by turning on fine tuning:

> python train_ohter_task.py --fine_tune True

Note that "fine_tune_delta" ($\tau_{up}$) and "fine_tune_ratio" ($\epsilon$) in config_init.json should be carefully adjusted to ensure the effectiveness of the fine tuning.

