# Open Language Model Evaluation System (OLMES)

## Introduction

The OLMES (Open Language Model Evaluation System) repository is used within [Ai2](XXXX)'s Open 
Language Model efforts to evaluate base and
instruction-tuned LLMs on a range of tasks. The repository includes code to faithfully reproduce the 
evaluation results in research papers such as
   * **OLMo:** Accelerating the Science of Language Models ([Groeneveld et al, 2024](XXXX))
   * **OLMES:** A Standard for Language Model Evaluations ([Gu et al, 2024](XXXX))
   * **TÜLU 3:** Pushing Frontiers in Open Language Model Post-Training ([Lambert et al, 2024](XXXX))
   * **OLMo 2:** *Reference coming soon*

The code base uses helpful features from the [lm-evaluation-harness](XXXX) 
by Eleuther AI, with a number of modifications and enhancements, including:

  * Support deep configurations for variants of tasks
  * Record more detailed data about instance-level predictions (logprobs, etc)
  * Custom metrics and metric aggregations
  * Integration with external storage options for results


## Setup

Start by cloning the repository and install dependencies (optionally creating a virtual environment,
Python 3.10 or higher is recommended):
```
git clone XXXX
cd olmes

conda create -n olmes python=3.10
conda activate olmes
pip install -e .
```

For running on GPUs (with vLLM), use instead `pip install -e .[gpu]`. If you get complaints regarding the 
`torch` version, downgrade to `torch>=2.2` in [pyproject.toml](pyproject.toml).

## Running evaluations

To run an evaluation with a specific model and task (or task suite):

```commandline
olmes --model olmo-1b --task arc_challenge::olmes --output-dir my-eval-dir1
```

This will launch the standard [OLMES](XXXX) 
version of [ARC Challenge](XXXX) 
(which uses a curated 5-shot example, trying both multiple-choice and cloze formulations, and reporting
the max) with the [pythia-1b model](XXXX), storing the output in `my-eval-dir1`

Multiple tasks can be specified after the `--task` argument, e.g.,
```commandline
olmes --model olmo-1b --task arc_challenge::olmes hellaswag::olmes --output-dir my-eval-dir1
```

Before starting an evaluation, you can sanity check using `--inspect`, which shows a sample prompt
(and does a tiny 5-instance eval with a small model)
```commandline
olmes --task arc_challenge:mc::olmes --inspect
```
You can also look at the fully expanded command of the job you are about launch using the `--dry-run` flag:
```commandline
olmes --model pythia-1b --task mmlu::olmes --output-dir my-eval-dir1 --dry-run
```

For a full list of arguments run `olmes --help`.


## Running specific evaluation suites

### OLMES standard - Original 10 multiple-choice tasks

To run all 10 multiple-choice tasks from the [OLMES paper](XXXX):
```
olmes --model olmo-7b --task core_9mcqa::olmes --output-dir <dir>
olmes --model olmo-7b --task mmlu::olmes --output-dir <dir>
```

### OLMo evaluations

To reproduce numbers in the [OLMo paper](XXXX):
```
olmes --model olmo-7b --task main_suite::olmo1 --output-dir <dir>
olmes --model olmo-7b --task mmlu::olmo1 --output-dir <dir>
```

### TÜLU 3 evaluations

The list of exact tasks and associated formulations used in the [TÜLU 3 
work](XXXX) 
can be found in these  suites in the [task suite library](oe_eval/configs/task_suites.py):
   *  `"tulu_3_dev"`: Tasks evaluated during development
   * `"tulu_3_unseen"`: Held-out task used during final evaluation

### OLMo 2 evaluations

The list of exact tasks and associated formulations used in the base model evaluations of the 
[OLMo 2 technical report]()
can be found in these suites in the [task suite library](oe_eval/configs/task_suites.py):
   * `"core_9mcqa::olmes"`: The core 9 multiple-choice tasks from original OLMES standard
   * `"mmlu:mc::olmes"`: The MMLU tasks in multiple-choice format
   * `"olmo_2_generative::olmes"`: The 5 generative tasks used in OLMo 2 development
   * `"olmo_2_heldout::olmes"`: The 5 held-out tasks used in OLMo 2 final evaluation



## Model configuration

Models can be directly referenced by their Huggingface model path, e.g., `--model allenai/OLMoE-1B-7B-0924`,
or by their key in the [model library](oe_eval/configs/models.py), e.g., `--model olmoe-1b-7b-0924` which
can include additional configuration options (such as `max_length` for max context size and `model_path` for
local path to model).

The default model type uses the Huggingface model implementations, but you can also use the `--model-type vllm` flag to use
the vLLM implementations for models that support it, as well as `--model-type litellm` to run API-based models.

You can specify arbitrary model arguments directly in the command line as well, e.g.
```commandline
olmes --model google/gemma-2b --model-args '{"trust_remote_code": True, "add_bos_token": True}' ...
```
To see a list of available models, run `oe-eval --list-models`, for a list of models containing a certain phrase,
you can follow this with a substring (any regular expression), e.g., `oe-eval --list-models llama`.


## Task configuration

To specify a task, use the [task library](oe_eval/configs/tasks.py) which have
entries like
```
"arc_challenge:rc::olmes": {
    "task_name": "arc_challenge",
    "split": "test",
    "primary_metric": "acc_uncond",
    "num_shots": 5,
    "fewshot_source": "OLMES:ARC-Challenge",
    "metadata": {
        "regimes": ["OLMES-v0.1"],
    },
},
```
Each task can also have custom entries for `context_kwargs` (controlling details of the prompt),
`generation_kwargs` (controlling details of the generation), and `metric_kwargs` (controlling details of the metrics). The `primary_metric` indicates which metric field will be reported as the "primary score" for the task.

The task configuration parameters can be overridden on the command line, these will generally apply to all tasks, e.g.,
```commandline
olmes --task arc_challenge:rc::olmes hellaswag::rc::olmes --split dev ...
```
but using a json format for each task, can be on per-task (but it's generally better to use the task 
library for this), e.g.,
```
olmes --task '{"task_name": "arc_challenge:rc::olmes", "num_shots": 2}' '{"task_name": "hellasag:rc::olmes", "num_shots": 4}' ...
```
For complicated commands like this, using `--dry-run` can be helpful to see the full command before running it.

To see a list of available tasks, run `oe-eval --list-tasks`, for a list of tasks containing a certain phrase,
you can follow this with a substring (any regular expression), e.g., `oe-eval --list-tasks arc`.

### Task suite configurations

To define a suite of tasks to run together, use the [task suite library](oe_eval/configs/task_suites.py),
with entries like:
```python
TASK_SUITE_CONFIGS["mmlu:mc::olmes"] = {
    "tasks": [f"mmlu_{sub}:mc::olmes" for sub in MMLU_SUBJECTS],
    "primary_metric": "macro",
}
```
specifying the list of tasks as well as how the metrics should be aggregated across the tasks.


## Evaluation output

The evaluation output is stored in the specified output directory, in a set of files
for each task. See [output formats](OUTPUT_FORMATS.md) for more details.

The output can optionally be stored in a Google Sheet by specifying the `--gsheet` argument (with authentication
stored in environment variable `GDRIVE_SERVICE_ACCOUNT_JSON`).

The output can also be stored in a Huggingface dataset directory by specifying the `--hf-save-dir` argument, 
a remote directory (like `s3://...`) by specifying the `--remote-output-dir` argument,
or in a W&B project by specifying the `--wandb-run-path` argument.
