from typing import Dict, Type

from oe_eval.tasks.base_task import Task

from . import (
    aime,
    alpaca_eval,
    arc,
    boolq,
    #codex_bigcodebench,
    #codex_humaneval,
    #codex_mbpp,
    copa,
    copycolors,
    coqa,
    cosmosqa,
    csqa,
    drop,
    gpqa,
    gpqa_diamond,
    gsm8k,
    hellaswag,
    ifeval,
    jeopardy,
    logiqa,
    minerva_math_500,
    naturalqs_open,
    openbookqa,
    piqa,
    popqa,
    sciq,
    siqa,
    squad,
    squad2,
    triviaqa,
    truthfulqa,
    winogrande,
)
from .agi_eval import create_core_agi_eval_tasks
from .bbh import create_core_bbh_tasks
from .deepmind_math import create_deepmind_math_tasks
from .minerva_math import create_core_math_tasks
from .mmlu import create_core_mmlu_tasks
from .mmlu_pro import create_core_mmlu_pro_cot_tasks, create_core_mmlu_pro_tasks
#from .mt_eval import create_core_mt_eval_tasks
from .tydiqa import create_core_tydiqa_tasks
from .zero_scrolls import create_core_zero_scrolls_tasks

TASK_REGISTRY: Dict[str, Type[Task]] = {
    **create_core_agi_eval_tasks(),
    "aime": aime.AIME,
    "alpaca_eval": alpaca_eval.AlpacaEval,
    "arc_challenge": arc.ARCChallenge,
    "arc_challenge:mc": arc.ARCChallengeMC,
    "arc_easy": arc.ARCEasy,
    "arc_easy:mc": arc.ARCEasyMC,
    **create_core_bbh_tasks(),
    #"bigcodebench": codex_bigcodebench.BigCodeBench,
    #"bigcodebench_hard": codex_bigcodebench.BigCodeBenchHard,
    "boolq": boolq.BoolQ,
    "boolq:mc": boolq.BoolQMC,
    #"codex_humaneval": codex_humaneval.CodexHumanEval,
    #"codex_humanevalplus": codex_humaneval.CodexHumanEvalPlus,
    "copa": copa.Copa,
    "copycolors": copycolors.CopyColors,
    "copycolors:mc": copycolors.CopyColorsMC,
    "coqa": coqa.CoQA,
    "cosmosqa": cosmosqa.CosmosQA,
    "cosmosqa:mc": cosmosqa.CosmosQAMC,
    "csqa": csqa.CommonsenseQA,
    "csqa:mc": csqa.CommonsenseQAMC,
    **create_deepmind_math_tasks(),
    "drop": drop.DROP,
    "gsm8k": gsm8k.GSM8K,
    "gsm8k_selfc": gsm8k.GSM8KSelfC,
    "gpqa": gpqa.GPQA,
    "gpqa_diamond": gpqa_diamond.GPQADiamond,
    "hellaswag": hellaswag.HellaSwag,
    "hellaswag:mc": hellaswag.HellaSwagMC,
    "ifeval": ifeval.IFEval,
    "jeopardy": jeopardy.Jeopardy,
    "logiqa": logiqa.LogiQA,
    "logiqa:mc": logiqa.LogiQAMC,
    **create_core_math_tasks(),
    "minerva_math_500": minerva_math_500.MATH500,
    # "mbpp": codex_mbpp.MBPP,
    # "mbppplus": codex_mbpp.MBPPPlus,
    # MMLU
    **create_core_mmlu_tasks(),
    **create_core_mmlu_pro_cot_tasks(),
    **create_core_mmlu_pro_tasks(),
    #**create_core_mt_eval_tasks(),
    "naturalqs_open": naturalqs_open.NaturalQsOpen,
    "openbookqa": openbookqa.OpenBookQA,
    "openbookqa:mc": openbookqa.OpenBookQAMC,
    "piqa": piqa.PiQA,
    "piqa:mc": piqa.PiQAMC,
    "popqa": popqa.PopQA,
    "sciq": sciq.SciQ,
    "socialiqa": siqa.SocialIQA,
    "socialiqa:mc": siqa.SocialIQAMC,
    "squad": squad.SQuAD,
    "squad2": squad2.SQuAD2,
    "triviaqa": triviaqa.TriviaQA,
    "truthfulqa": truthfulqa.TruthfulQA,
    **create_core_tydiqa_tasks(),
    "winogrande": winogrande.Winogrande,
    "winogrande:mc": winogrande.WinograndeMC,
    **create_core_zero_scrolls_tasks(),
}
