#!/bin/bash

export PYENV_ROOT="$HOME/.pyenv"
export PATH="$PYENV_ROOT/bin:$PATH"
eval "$(pyenv init --path)"
eval "$(pyenv init -)"
eval "$(pyenv virtualenv-init -)"

pwd; hostname; date
python -V

pyenv activate mbrl-dev

echo "Started with params {{ task }}, {{ reducer }}, {{ seed }}"
python -m mbrl.examples.main \
    algorithm=uasc \
    overrides=uasc_{{ task }} \
    overrides.actor_train_unroll_merge={{ reducer }} \
    seed={{ seed }} \
    experiment="lph"

date
