# 💡Usage
## ⚙️ Runtime Environment
### GPU (Nvidia)
(1) Prepare the environment

```
conda create -n flashi2v python=3.10
conda activate flashi2v
```
(2) Install dependencies
```
pip install -r requirements.txt
```
(3) Install flash attn
```
pip install flash-attn --no-build-isolation
```
(4) build
```
pip install -e .
```
### NPU (Ascend)
(1) Prepare the environment
```
conda create -n flashi2v python=3.10
conda activate flashi2v
```
(2) Install dependencies
```
pip install -r requirements.txt
```
(3) Install decord
```
git clone --recursive https://github.com/dmlc/decord
mkdir build && cd build 
cmake .. -DUSE_CUDA=0 -DCMAKE_BUILD_TYPE=Release -DFFMPEG_DIR=/usr/local/ffmpeg 
make 
cd ../python 
pwd=$PWD 
echo "PYTHONPATH=$PYTHONPATH:$pwd" >> ~/.bashrc 
source ~/.bashrc 
python3 setup.py install --user
```
(4) build
```
pip install -e .
```
## 🍕 Sample Image-to-Video
```
bash scripts/infer/*pu/infer_flashi2v_*b.sh
```
## 🧑‍🏭 Train Image-to-Video
### 🤾 Training
```
bash scripts/train/*pu/train_flashi2v_*b.sh
```
